//store.c:

/*
 *      Copyright (C) Philipp 'ph3-der-loewe' Schafft - 2009-2011
 *
 *  This file is part of RoarAudio PlayList Daemon,
 *  a playlist management daemon for RoarAudio.
 *  See README for details.
 *
 *  This file is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 3
 *  as published by the Free Software Foundation.
 *
 *  RoarAudio is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 *
 */

#include "rpld.h"

static char * _g_path = NULL;

static char * _astr(size_t * s) {
 size_t len;

 if ( _g_path == NULL )
  return NULL;

 len = strlen(_g_path);

 *s = len+1 /* slash */ + 32 /* pl-* */;

 return (char*) malloc(*s);
}

static void _mkfile(char * buf, size_t len, const char * path, const char * file) {
 snprintf(buf, len, "%s/%s", path, file);
 buf[len-1] = 0;
}

int store (void) {
 struct fformat_handle * format;
 struct rpld_playlist * pl;
 struct roar_vio_calls index, pointer, export, volume;
 struct roar_vio_defaults def;
 unsigned int i;
 char * buf;
 size_t len;
#ifdef HAVE_LIB_UUID
 char uuid[37];
#endif

 // TODO: free format...

 if ( _g_path == NULL )
  return -1;

 if ( (format = fformat_handle_new(RPLD_FF_PLF_DEFAULT)) == NULL )
  return -1;

 if ( roar_vio_dstr_init_defaults(&def, ROAR_VIO_DEF_TYPE_NONE, O_WRONLY|O_CREAT|O_TRUNC, 0644) == -1 ) {
  fformat_handle_close(format);
  return -1;
 }

 if ( (buf = _astr(&len)) == NULL ) {
  fformat_handle_close(format);
  return -1;
 }

 _mkfile(buf, len, _g_path, "pointer");

 if ( roar_vio_open_dstr(&pointer, buf, &def, 1) == -1 ) {
  fformat_handle_close(format);
  return -1;
 }

 for (i = 0; i < sizeof(g_pointer)/sizeof(*g_pointer); i++) {
  if ( g_pointer[i].pointer == NULL )
   continue;
  switch (g_pointer[i].pointer->pls.type) {
   case RPLD_PL_ST_TRACKNUM_LONG:
     roar_vio_printf(&pointer, "POINTER: \"%s\" -> long:0x0x%.16LX\n", g_pointer[i].name,
                               g_pointer[i].pointer->pls.subject.long_tracknum);
    break;
   case RPLD_PL_ST_TRACKNUM_SHORT:
     roar_vio_printf(&pointer, "POINTER: \"%s\" -> short:0x0x%.8X\n", g_pointer[i].name,
                               g_pointer[i].pointer->pls.subject.short_tracknum);
    break;
#ifdef HAVE_LIB_UUID
   case RPLD_PL_ST_UUID:
     uuid_unparse(g_pointer[i].pointer->pls.subject.uuid, uuid);
     roar_vio_printf(&pointer, "POINTER: \"%s\" -> uuid:%s\n", g_pointer[i].name, uuid);
    break;
#endif
   case RPLD_PL_ST_RANDOM:
     roar_vio_printf(&pointer, "POINTER: \"%s\" -> random:%i\n", g_pointer[i].name,
                               g_pointer[i].pointer->pls.subject.pl);
    break;
   case RPLD_PL_ST_RANDOM_LIKENESS:
     roar_vio_printf(&pointer, "POINTER: \"%s\" -> randomlike:%i\n", g_pointer[i].name,
                               g_pointer[i].pointer->pls.subject.pl);
    break;
  }
 }

 roar_vio_close(&pointer);


 _mkfile(buf, len, _g_path, "volume");

 if ( roar_vio_open_dstr(&volume, buf, &def, 1) == -1 ) {
  fformat_handle_close(format);
  return -1;
 }

 roar_vio_printf(&volume, "%i\n", (int)playback_get_volume_mu16());

 roar_vio_close(&volume);


 _mkfile(buf, len, _g_path, "index");

 if ( roar_vio_open_dstr(&index, buf, &def, 1) == -1 ) {
  fformat_handle_close(format);
  return -1;
 }

 for (i = 0; i < MAX_PLAYLISTS; i++) {
  pl = rpld_pl_get_by_id(i);
  if ( pl != NULL ) {
   roar_vio_printf(&index, "PL: %i:%i:X:%s:\n",
                                        rpld_pl_get_id(pl),
                                        rpld_pl_get_parent(pl),
                                        rpld_pl_get_name(pl)
                  );
/*
int                     fformat_playlist_export(struct fformat_handle * handle,
                                                struct roar_vio_calls * vio,
                                                struct rpld_playlist  * pl);
*/
   snprintf(buf, len, "%s/pl-%i", _g_path, rpld_pl_get_id(pl));
   buf[len-1] = 0;
   if ( roar_vio_open_dstr(&export, buf, &def, 1) == -1 ) {
    roar_vio_close(&index);
    fformat_handle_close(format);
    return -1;
   }

   fformat_playlist_export(format, &export, pl);

   roar_vio_close(&export);
  }
 }

 roar_vio_close(&index);

 fformat_handle_close(format);
 return 0;
}

int restore (void) {
 struct fformat_handle * format;
 struct rpld_playlist * pl;
 struct roar_vio_calls index, pointer, import, volume;
 struct roar_vio_defaults def;
 int i;
 char * buf;
 char lion[1024];
 struct {
  int id;
  int parent;
 } ie;
 size_t len;
 char * div[5];
 struct rpld_playlist_pointer ** cpointer;
 struct rpld_playlist_search     pls;
 int pointer_needs_update[sizeof(g_pointer)/sizeof(*g_pointer)];
 int cpointer_id;
 int volume_val;

 memset(pointer_needs_update, 0, sizeof(pointer_needs_update));

 // TODO: free format...

 if ( _g_path == NULL )
  return -1;

 if ( (format = fformat_handle_new(RPLD_FF_PLF_DEFAULT)) == NULL )
  return -1;

 if ( roar_vio_dstr_init_defaults(&def, ROAR_VIO_DEF_TYPE_NONE, O_RDONLY, 0644) == -1 ) {
  fformat_handle_close(format);
  return -1;
 }

 if ( (buf = _astr(&len)) == NULL ) {
  fformat_handle_close(format);
  return -1;
 }

 _mkfile(buf, len, _g_path, "pointer");

 if ( roar_vio_open_dstr(&pointer, buf, &def, 1) == -1 ) {
  fformat_handle_close(format);
  return -1;
 }

 while (roar_vio_fgets(&pointer, lion, sizeof(lion)) != NULL) {
  if ( !strncmp(lion, "POINTER: \"", 10) ) {
   div[0] = lion+10;
   div[1] = strstr(div[0], "\" -> ");
   if ( div[1] == NULL )
    continue;

   ROAR_DBG("restore() = ?");

   *div[1]  = 0;
    div[1] += 5;

   cpointer = NULL;
   for (i = 0; (i < (int)(sizeof(g_pointer)/sizeof(*g_pointer))) && cpointer == NULL; i++) {
    if ( !strcmp(div[0], g_pointer[i].name) ) {
     cpointer = &(g_pointer[i].pointer);
     cpointer_id = i;
    }
   }

   ROAR_DBG("restore() = ?");

   if ( cpointer == NULL )
    continue;

   ROAR_DBG("restore() = ?");

   if ( *cpointer != NULL ) {
    rpld_plp_uninit(*cpointer);
    *cpointer = NULL;
   }

   div[2]  = strstr(div[1], ":");
   if ( div[2] == NULL )
    continue;

   ROAR_DBG("restore() = ?");

   *div[2]  = 0;
    div[2]++;

   memset(&pls, 0, sizeof(pls));

   ROAR_DBG("restore() = ?");

   i = strlen(div[2]) - 1;
   for (; i > -1; i--) {
    if ( div[2][i] == '\r' || div[2][i] == '\n' ) {
     div[2][i] = 0;
    } else {
     break;
    }
   }

   if ( !strcmp(div[1], "uuid") ) {
#ifdef HAVE_LIB_UUID
    ROAR_DBG("restore(): uuid='%s'", div[2]);
    pls.type = RPLD_PL_ST_UUID;
    if ( uuid_parse(div[2], pls.subject.uuid) != 0 )
     continue;

    ROAR_DBG("restore() = ?");
#else
    ROAR_WARN("restore(): Unsupported search schema: %s", div[1]);
    continue;
#endif
   } else if ( !strcmp(div[1], "random") ) {
    pls.type = RPLD_PL_ST_RANDOM;
    pls.subject.pl = atoi(div[2]);
    pointer_needs_update[cpointer_id] = 1;
   } else if ( !strcmp(div[1], "randomlike") ) {
    pls.type = RPLD_PL_ST_RANDOM_LIKENESS;
    pls.subject.pl = atoi(div[2]);
    pointer_needs_update[cpointer_id] = 1;
   } else {
    ROAR_WARN("restore(): Unsupported search schema: %s", div[1]);
    continue;

    ROAR_DBG("restore() = ?");
   }

   *cpointer = rpld_plp_init(NULL, &pls);

   ROAR_DBG("restore(): *cpointer=%p", *cpointer);
  }
 }

 roar_vio_close(&pointer);


 _mkfile(buf, len, _g_path, "volume");

 if ( roar_vio_open_dstr(&volume, buf, &def, 1) != -1 ) {
  if ( roar_vio_fgets(&pointer, lion, sizeof(lion)) != NULL ) {
   volume_val = atoi(lion);
   //printf("volume_val=%i\n", volume_val);
   if ( volume_val != 0 )
    playback_set_volume_mu16(volume_val);
  }

  roar_vio_close(&volume);
 }


 _mkfile(buf, len, _g_path, "index");

 if ( roar_vio_open_dstr(&index, buf, &def, 1) == -1 ) {
  fformat_handle_close(format);
  return -1;
 }

 memset(&ie, 0, sizeof(ie));

 while (roar_vio_fgets(&index, lion, sizeof(lion)) != NULL) {
  if ( !strncmp(lion, "PL: ", 4) ) {
   div[0] = lion+4;
   for (i = 1; i < 5; i++) {
     div[i] = strstr(div[i-1], ":");
    *div[i] = 0;
     div[i]++;
   }

/*
   for (i = 0; i < 5; i++) {
    printf("div[i=%i] = '%s'\n", i, div[i]);
   }
*/

   ie.id     = atoi(div[0]);
   ie.parent = atoi(div[0]);

   if ( ie.id == 0 ) {
    pl = g_queue;
   } else if ( ie.id == 1 ) {
    pl = g_history;
   } else {
    pl = rpld_pl_new();
    rpld_pl_set_name(pl, div[3]);
    rpld_pl_register(pl);
//    printf("reg=%i\n", rpld_pl_register(pl));
   }
//   printf("pl=%p, name='%s'\n", pl, div[3]);
   if ( pl != NULL ) {
    // update pointers to match PLI with new generated one:
    for (i = 0; (i < (int)(sizeof(g_pointer)/sizeof(*g_pointer))); i++) {
     if ( pointer_needs_update[i] ) {
      if ( g_pointer[i].pointer->pls.subject.pl == (pli_t)ie.id ) {
       g_pointer[i].pointer->pls.subject.pl = rpld_pl_get_id(pl);
       pointer_needs_update[i] = 0;
      }
     }
    }

    snprintf(buf, len, "%s/pl-%i", _g_path, ie.id);
    buf[len-1] = 0;
    if ( roar_vio_open_dstr(&import, buf, &def, 1) == -1 ) {
     roar_vio_close(&index);
     fformat_handle_close(format);
     return -1;
    }

    fformat_playlist_import(format, &import, pl);

    roar_vio_close(&import);
   }
  }
 }

 roar_vio_close(&index);

 fformat_handle_close(format);
 return 0;
}

int setstorepath(char * path) {

 if ( path == NULL )
  return -1;

 if ( *path == 0 )
  return -1;

 _g_path = path;

 return 0;
}

//ll
