///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
#include "rheolef/config.h"

#ifndef _RHEOLEF_HAVE_MPI
int main() { return 0; }
#else // _RHEOLEF_HAVE_MPI

#include "rheolef/polymorphic_array.h"
#include "geo_element_tst.h"
using namespace rheolef;
using namespace std;
int main(int argc, char**argv)
{
    environment distributed(argc, argv);
    communicator comm;

    size_t n = 6;
    polymorphic_array<geo_element>   omega (n);
    if (comm.rank() == 0) {
      // init a mesh:
      warning_macro ("STEP 1: insert...")
      omega.data().set_dis_entry (0, geo_element_t (1,2,31));
      omega.data().set_dis_entry (1, geo_element_T (11,12,13,14));
      omega.data().set_dis_entry (2, geo_element_t (4,5,6));
      omega.data().set_dis_entry (3, geo_element_T (15,16,17,18));
      omega.data().set_dis_entry (4, geo_element_P (7,8,9,10,11,12));
      omega.data().set_dis_entry (5, geo_element_t (7,8,9));
      // modify the mesh:
      warning_macro ("STEP 2: modify...")
      omega.data().set_dis_entry (0, geo_element_t (1,2,3));
      omega.data().set_dis_entry (1, geo_element_q (11,12,13,14));
      omega.data().set_dis_entry (5, geo_element_H (31,32,33,34,35,36,37,38));
    }
    omega.dis_entry_assembly_begin();
    omega.dis_entry_assembly_end();
    // output:
    dcout << "geo " << omega.dis_size() << endl;
    omega.put_values (dcout);
}
#endif // _RHEOLEF_HAVE_MPI
