#ifndef _RHEOLEF_ASR_STORE_H
#define _RHEOLEF_ASR_STORE_H
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// =========================================================================
namespace rheolef {
//
// implementation for asr sparse matrix
//
//
// TODO: use a guest, for asr_begin_assembly, since previous insert is
// 	close to the current one if the row is the same...
//  	elements are ordered
//   and clean explicit type map<..> references..
//
// Triplet = ((i,j),aij) = pair<pair<uint,uint>,double> or such
//
template <class OutputRandomIterator, class SetOp>
struct asr_store {
    typedef typename std::iterator_traits<OutputRandomIterator>::value_type Map;
    typedef typename Map::iterator   Iterator;
    typedef typename Map::value_type Pair;
    typedef typename Map::size_type  Size;
    typedef typename Pair::second_type T;
    typedef typename std::pair<std::pair<Size,Size>,T> data_type;
    void operator()(const std::pair<std::pair<Size,Size>,T>& aij) { 
	std::pair<Iterator,bool> status
	 = _x [aij.first.first].insert(Pair(aij.first.second,aij.second));
	if (!status.second) {
	    // an entry already exists: add some
	    _op ((*(status.first)).second, aij.second);
	} else {
	    // registers a new entry
	    _nnz++;
	}
    }
    Size n_new_entry() const { return _nnz; }
    asr_store(OutputRandomIterator x, SetOp op)
      : _x(x), _op(op), _nnz(0) {}
    OutputRandomIterator _x;
    SetOp                _op;
    Size                 _nnz;
};
template <class OutputRandomIterator, class SetOp>
inline
asr_store<OutputRandomIterator, SetOp>
asr_make_store(OutputRandomIterator x, SetOp op)
{
    return asr_store<OutputRandomIterator, SetOp>(x,op);
}
} // namespace rheolef
#endif // _RHEOLEF_ASR_STORE_H
