# ifndef _SKIT_ASRREP_H
# define _SKIT_ASRREP_H
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// =========================================================================
//
// ASRREP: Associative Sparse Row format
//         representation
//
// author: Pierre.Saramito@imag.fr
//
// date: 5 march 1997
//
# include "rheolef/skitbase.h"
namespace rheolef { 
template<class T>
class asrrep : public occurence, public std::vector<std::map<Index, T, std::less<Index> > > 
{
  public:
    typedef std::map<Index, T, std::less<Index> > row;
    typedef std::vector<row> data_type;
    asrrep(Index nrow = 0, Index ncol = 0)
      : occurence(), data_type(nrow), NCOL(ncol), NNZ(0) {}
    asrrep(const asrrep& a) 
      : occurence(), data_type(a), NCOL(a.NCOL), NNZ(a.NNZ) {}
    Index nrow() const { return data_type::size(); }
    Index ncol() const { return NCOL; }
    Index nnz() const { return NNZ; }
    T& entry (Index i, Index j);
    T operator() (Index i, Index j) const;
  private:
    Index NCOL;
    Index NNZ;
};
template <class T>
inline
T&
asrrep<T>::entry (Index i, Index j)
{
    typename row::iterator iter_j_aij  = data_type::operator[](i).find(j);
    bool exists = (iter_j_aij != data_type::operator[](i).end());
    if (exists) {
	return (*iter_j_aij).second;
    } else {
	NNZ++;
	return (data_type::operator[](i)).operator[](j);
    }
}
template <class T>
inline
T
asrrep<T>::operator() (Index i, Index j) const
{
    typename row::const_iterator iter_j_aij  = data_type::operator[](i).find(j);
    bool exists = (iter_j_aij != data_type::operator[](i).end());
    if (exists) {
	return (*iter_j_aij).second;
    } else {
	return T();
    }
}
}// namespace rheolef
# endif // _SKIT_ASRREP_H
