#ifndef _RHEO_CONVECT_H
#define _RHEO_CONVECT_H
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// =========================================================================

/*Class:convect
NAME: @code{convect} -- discontinuous Galerkin
@bfindex convect
@apindex P1d
@clindex space
SYNOPSIS:
    @example
        form(const space& V, const space& V, "convect", uh);
    @end example
DESCRIPTION:       
    @noindent
    Assembly the matrix associated to the
    discontinuous Galerkin method on the finite element space V.
@iftex
    $$
   	c(u,v) = \int_\Omega  a.grad(u) v \, dx + skips...
    $$
    for all $u,v \in V$, where the vector field $a$ is given.
@end iftex
@ifnottex
    @example
                 /
                 |
   	c(u,v) = |  a.grad(u) v dx + skips...
                 |
                 / Omega
    @end example
    for all u,v in V, where the vector field a is given.
@end ifnottex
    @noindent
    The V space may @code{P1d}
    finite element spaces for building the form.
End:
*/

#include "rheolef/form_element_rep.h"
namespace rheolef { 

class convect: public form_element_rep {
public:
// allocator:

    convect() : form_element_rep() {}

// virtual accessor:

    void operator() (const geo_element& K, ublas::matrix<Float>& m) const;
    void check_after_initialize () const;
};
}// namespace rheolef
#endif // _RHEO_CONVECT_H
