#ifndef _RHEO_2W_H
#define _RHEO_2W_H
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// =========================================================================

/*Class:2W
NAME: @code{2W} -- vorticity tensor
@bfindex 2W
@cindex  vorticity tensor
@cindex  tensor
@clindex form
@clindex space
@apindex P0
@apindex P1
@apindex P2
@apindex P1d
SYNOPSIS:
  @example
    	form (const space V, const space& T, "2W");
  @end example
DESCRIPTION:       
  @noindent
  Assembly the form associated to the vorticity
  tensor, i.e. the unsymmetric part of the gradient of a 
  vector field.
  These derivative are usefull in fluid mechanic.
@iftex
  $$
      b({\bf u},\tau) = \int_\Omega 
         2W({\bf u}) : \, \tau \, dx,
    \forall u \in V \ {\rm and }\  q \in T.
  $$
  where
  $$
     2 D({\bf u}) = \nabla {\bf u} - \nabla {\bf u}^T
  $$
@end iftex
@ifnottex
  @example
                 /
                 |
      b(u,tau) = | 2 W(u) : tau dx,
                 |
                 / Omega 
  @end example
  where
  @example
     2 D(u) = grad u - (grad u)^T
  @end example
@end ifnottex
  @noindent
  If the V space is a vector-valued @code{P1} (resp. @code{P2})
  finite element space, the T space may be
  a tensor-valued @code{P0} (resp. @code{P1d}) one.

EXAMPLE:
  @noindent
  The following piece of code build the Laplacian form
  associated to the P1 approximation:
  @example
   	geo omega ("square");
   	space V (omega, "P1", "vector");
   	space T (omega, "P0", "tensor");
   	form  b (V, T, "2W");
  @end example
AUTHOR: 
    LMC-IMAG, 38041 Grenoble cedex 9, France
    | Pierre.Saramito@imag.fr
SEE ALSO:
    "form"(3)
DATE:
    28 november 1997
End:
*/

#include "rheolef/form_element_rep.h"
namespace rheolef { 

class _2W: public form_element_rep {

public:
// allocator:

    _2W() : form_element_rep() {}

// virtual accessor:

    void operator() (const geo_element& K, ublas::matrix<Float>& m) const;
    size_type n_derivative() const;
};
}// namespace rheolef
#endif // _RHEO_2W_H
