/*
 * shell.c - The RefDbg shell
 *
 * refdbg - GObject refcount debugger
 * Copyright (C) 2004-2005 Josh Green <jgreen@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA or point your web browser to http://www.gnu.org.
 */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <glib.h>
#include <string.h>

#ifdef READLINE_SUPPORT
#include <readline/readline.h>
#include <readline/history.h>
#else
#warning No readline! We go cry now :(
#endif

#include "refdbg.h"
#include "refdbg_priv.h"


/* set by refdbg_exec() when the "exit" command occurs */
gboolean refdbg_exit;


/*
 * Starts the RefDbg shell.
 */
#ifdef READLINE_SUPPORT

void
refdbg (void)
{
  char *line;

  if (!REFDBG_TRYLOCK) {
    g_critical ("Can't run shell: refdbg data is locked (breakpoint in"
        " refdbg code?)");
    return;
  }

  REFDBG_UNLOCK;

  refdbg_exit = FALSE;

  do {
    line = readline (REFDBG_PROMPT);
    if (line) {
      refdbg_cmd (line);
      add_history (line);
    }
  }
  while (!refdbg_exit);
}

#else /* no readline support? */

void
refdbg (void)
{
  char line[256];
  int len;

  if (!REFDBG_TRYLOCK) {
    g_critical ("Can't run shell: refdbg data is locked (breakpoint in"
        " refdbg code?)");
    return;
  }

  REFDBG_UNLOCK;

  refdbg_exit = FALSE;

  do {
    fprintf (stderr, REFDBG_PROMPT);
    fgets (line, sizeof (line), stdin);

    if (line) {
      len = strlen (line);

      /* kill the newline */
      if (line[len - 1] == '\n')
        line[len - 1] = '\0';

      if (*line)
        refdbg_cmd (line);
    }
  }
  while (!refdbg_exit);
}

#endif
