/*
 * refdbg.h - Main refdbg header file
 *
 * refdbg - GObject refcount debugger
 * Copyright (C) 2004-2005 Josh Green <jgreen@users.sourceforge.net>
 *               2010 Stefan Kost <ensonic@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA or point your web browser to http://www.gnu.org.
 */
#ifndef __REFDBG_H__
#define __REFDBG_H__

#include <stdio.h>

/* defines the RefDbg shell prompt string */
#define REFDBG_PROMPT "<RefDbg> "

/* default number of stack frames to store for each ref/unref event */
#define REFDBG_DEFAULT_BACKTRACE_COUNT 4

/* maximum number of runtime configurable stack trace entries */
#define REFDBG_MAX_BACKTRACE_COUNT 32

/* maximum number of event rules (including default rule) */
#define REFDBG_MAX_EVENT_RULES 10

/* default file name of the log file for refdbg_save_log() */
#define REFDBG_DEFAULT_LOGNAME "refdbg.log"

/* default maximum results to display with 'display' command and others */
#define REFDBG_DEFAULT_DISPMAX 100

/* timer interval (for processing refcount timer expires) */
#define REFDBG_TIMER_INTERVAL  250 /* in milliseconds */

/* -- defined in shell.c -- */

/* the RefDbg shell - An interactive RefDbg command shell */
void refdbg (void);

/* -- defined in help.c -- */
void refdbg_help (const char *topic); /* get help */

/* -- defined in user.c -- */

void refdbg_stats (void);	/* print statistics */
void refdbg_save_log (void);   /* print events to file log file */

/* -- defined in cmdparse.c -- */
gboolean refdbg_cmd (const char *cmds);	/* execute refdbg commands */

#endif
