#include "rcui.h"

#include <engine/engine.h>
#include "engine/engine-private.h"

extern RcEngine *RC_engine;

gboolean RCUI_name_is_in_list (GtkListStore *list_store, gchar *what, GtkTreeIter *piter)
{
  gboolean valid;
  gboolean found = FALSE;
  gchar *name;
  
  if (strlen(what) == 0)
    return FALSE;
  
  /* destruction des lignes existantes */
  valid = gtk_tree_model_get_iter_first (GTK_TREE_MODEL(list_store), piter);
  while (valid && !found)
  {
    gtk_tree_model_get (GTK_TREE_MODEL(list_store), piter, NAME_COLUMN, &name, -1);
    if (!g_ascii_strcasecmp(what, name)) 
      found=TRUE;
    else
      valid = gtk_tree_model_iter_next (GTK_TREE_MODEL(list_store), piter);
  }
  
  return found;
}

void RCUI_get_iter_by_name (GtkListStore *list_store, gchar *what, GtkTreeIter *piter)
{
  gboolean valid;
  gboolean found = FALSE;
  gchar *name;
  
  /* destruction des lignes existantes */
  valid = gtk_tree_model_get_iter_first (GTK_TREE_MODEL(list_store), piter);
  while (valid && !found)
  {
    gtk_tree_model_get (GTK_TREE_MODEL(list_store), piter, NAME_COLUMN, &name, -1);
    if (!g_ascii_strcasecmp(what, name)) 
      found=TRUE;
    else
      valid = gtk_tree_model_iter_next (GTK_TREE_MODEL(list_store), piter);
  }
}
