/*
 * RageIRCd: an advanced Internet Relay Chat daemon (ircd).
 * (C) 2000-2005 the RageIRCd Development Team, all rights reserved.
 *
 * This software is free, licensed under the General Public License.
 * Please refer to doc/LICENSE and doc/README for further details.
 *
 * $Id: rc4.c,v 1.11.2.1 2004/12/07 03:05:31 pneumatus Exp $
 */

#include "setup.h"
#include "ssl.h"
#include "memory.h"
#include "common.h"

#ifdef USE_OPENSSL

void *rc4_initstate(unsigned char *key, int keylen)
{
	RC4_word i;
	RC4_byte tmp, idx1 = 0, idx2 = 0;
	RC4_state *rc4;

	ASSERT(sizeof(RC4_byte) == 1);
	ASSERT(sizeof(RC4_word) == 4);

	rc4 = (RC4_state *)MyMalloc(sizeof(RC4_state));

	for (i = 0; i < 256; i++) {
		rc4->mstate[i] = (RC4_byte)i;
	}
	for (i = 0; i < 256; i++) {
		idx2 = (key[idx1++] + rc4->mstate[i] + idx2);

		tmp = rc4->mstate[i];
		rc4->mstate[i] = rc4->mstate[idx2];
		rc4->mstate[idx2] = tmp;

		if (idx1 >= keylen) {
			idx1 = 0;
		}
	}

	return (void *)rc4;
}

void rc4_process_stream(void *rc4_context, unsigned char *istring, unsigned int stringlen)
{
	RC4_state *rc4 = (RC4_state *)rc4_context;
	RC4_byte *s = rc4->mstate;
	RC4_word x = rc4->x, y = rc4->y;

	while (stringlen--) {
		RC4_word a, b;

		x = (x + 1) & 0xFF;
		a = s[x];
		y = (y + a) & 0xFF;
		b = s[y];
		s[x] = b;
		s[y] = a;
		*istring++ ^= s[(a + b) & 0xFF];
	}

	rc4->x = (RC4_byte)x;
	rc4->y = (RC4_byte)y;
}

void rc4_process_stream_to_buf(void *rc4_context, const unsigned char *istring, unsigned char *ostring,
	unsigned int stringlen)
{
	RC4_state *rc4 = (RC4_state *)rc4_context;
	RC4_byte *s = rc4->mstate;
	RC4_word x = rc4->x, y = rc4->y;

	while (stringlen--) {
		RC4_word a, b;

		x = (x + 1) & 0xFF;
		a = s[x];
		y = (y + a) & 0xFF;
		b = s[y];
		s[x] = b;
		s[y] = a;
		*ostring++ = *istring++ ^ s[(a + b) & 0xFF];
	}

	rc4->x = (RC4_byte)x;
	rc4->y = (RC4_byte)y;
}

void rc4_destroystate(void *rc4_context)
{
	memset(rc4_context, '\0', sizeof(RC4_state));
	MyFree(rc4_context);
}

#endif
