/*
 * RageIRCd: an advanced Internet Relay Chat daemon (ircd).
 * (C) 2000-2005 the RageIRCd Development Team, all rights reserved.
 *
 * This software is free, licensed under the General Public License.
 * Please refer to doc/LICENSE and doc/README for further details.
 *
 * $Id: inet_addr.c,v 1.15.2.1 2004/12/07 03:05:12 pneumatus Exp $
 */

/*
 * Copyright (c) 1996-1999 by Internet Software Consortium.
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND INTERNET SOFTWARE CONSORTIUM DISCLAIMS
 * ALL WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL INTERNET SOFTWARE
 * CONSORTIUM BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
 * PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 *
 * Contains code by Thomas Helvey and Paul Vixie.
 */

#include "setup.h"
#include "struct.h"
#include "common.h"
#include "sys.h"
#include "memory.h"
#include "setup.h"
#include "h.h"

static const char *inet4_octet_tab[] = {
	"0", "1", "2", "3", "4", "5", "6", "7", "8", "9",
	"10", "11", "12", "13", "14", "15", "16", "17", "18", "19",
	"20", "21", "22", "23", "24", "25", "26", "27", "28", "29",
	"30", "31", "32", "33", "34", "35", "36", "37", "38", "39",
	"40", "41", "42", "43", "44", "45", "46", "47", "48", "49",
	"50", "51", "52", "53", "54", "55", "56", "57", "58", "59",
	"60", "61", "62", "63", "64", "65", "66", "67", "68", "69",
	"70", "71", "72", "73", "74", "75", "76", "77", "78", "79",
	"80", "81", "82", "83", "84", "85", "86", "87", "88", "89",
	"90", "91", "92", "93", "94", "95", "96", "97", "98", "99",
	"100", "101", "102", "103", "104", "105", "106", "107", "108", "109",
	"110", "111", "112", "113", "114", "115", "116", "117", "118", "119",
	"120", "121", "122", "123", "124", "125", "126", "127", "128", "129",
	"130", "131", "132", "133", "134", "135", "136", "137", "138", "139",
	"140", "141", "142", "143", "144", "145", "146", "147", "148", "149",
	"150", "151", "152", "153", "154", "155", "156", "157", "158", "159",
	"160", "161", "162", "163", "164", "165", "166", "167", "168", "169",
	"170", "171", "172", "173", "174", "175", "176", "177", "178", "179",
	"180", "181", "182", "183", "184", "185", "186", "187", "188", "189",
	"190", "191", "192", "193", "194", "195", "196", "197", "198", "199",
	"200", "201", "202", "203", "204", "205", "206", "207", "208", "209",
	"210", "211", "212", "213", "214", "215", "216", "217", "218", "219",
	"220", "221", "222", "223", "224", "225", "226", "227", "228", "229",
	"230", "231", "232", "233", "234", "235", "236", "237", "238", "239",
	"240", "241", "242", "243", "244", "245", "246", "247", "248", "249",
	"250", "251", "252", "253", "254", "255"
};

const char *inetntoa(const char *in)
{
	static char buf[16];
	char *p = buf;
	const unsigned char *addr = (const unsigned char *)in, *n;
	int i;

	for (i = 0; i <= 3; i++) {
		n = inet4_octet_tab[*addr++];
		while (*n != '\0') {
			*p++ = *n++;
		}
		if (i < 3) {
			*p++ = '.';
		}
	}
	*p = '\0';

	return buf;
}

#ifndef INADDRSZ
#define INADDRSZ 4
#endif

const char *inetntop(const void *src, char *dest, unsigned int size)
{
	if (size < 16) {
		return NULL;
	}
	return strcpy(dest, inetntoa((const char *)src));
}

int inetpton(const char *src, void *dest)
{
	int digits = 0, octets = 0, c;
	unsigned char tmp[INADDRSZ], *p = tmp;

	*p = '\0';
	while ((c = *src++) != '\0') {
		if (c >= '0' && (c <= '9')) {
			unsigned int new = *p * 10 + (c - '0');

			if (new > 255) {
				return 0;
			}

			*p = new;

			if (!digits) {
				if (++octets > 4) {
					return 0;
				}
				digits = 1;
			}
		}
		else if (c == '.' && digits) {
			if (octets == 4) {
				return 0;
			}

			*++p = '\0';
			digits = 0;
		}
		else {
			return 0;
		}
	}
	if (octets < 4) {
		return 0;
	}

	memcpy(dest, tmp, INADDRSZ);
	return 1;
}

int parse_ipv4_netmask(const char *str, struct in_addr *addr, int *b)
{
	const char *p, *digits[4];
	unsigned char addb[4];
	int n = 0, bits = 0;
	char c;

	digits[n++] = str;

	for (p = str; (c = *p); p++) {
		if (c >= '0' && c <= '9') {
			/* Nothing */
		}
		else if (c == '.') {
			if (n >= 4) {
				return 0;
			}
			digits[n++] = (p + 1);
		}
		else if (c == '*') {
			if ((*(p + 1) != '\0') || !n || (*(p - 1) != '.')) {
				return 0;
			}
			bits = (n - 1) * 8;
			break;
		}
		else if (c == '/') {
			char *after;

			bits = strtoul((p + 1), &after, 10);

			if (!bits || (*after != '\0')) {
				return 0;
			}
			if (bits > (n * 8)) {
				return 0;
			}
			break;
		}
		else {
			return 0;
		}
	}

	if ((n < 4) && !bits) {
		bits = (n * 8);
	}
	if (bits) {
		while (n < 4) {
			digits[n++] = "0";
		}
	}

	for (n = 0; n < 4; n++) {
		addb[n] = strtoul(digits[n], NULL, 10);
	}

	if (!bits) {
		bits = 32;
	}
	if ((bits < 32) && (bits % 8)) {
		addb[bits / 8] &= ~((1 << (8 - bits % 8)) - 1);
	}

	for (n = bits / 8 + (bits % 8 ? 1 : 0); n < 4; n++) {
		addb[n] = 0;
	}

	if (addr != NULL) {
		addr->s_addr = htonl(addb[0] << 24 | addb[1] << 16 | addb[2] << 8 | addb[3]);
	}
	if (b != NULL) {
		*b = bits;
	}

	return 1;
}
