/*
 * RageIRCd: an advanced Internet Relay Chat daemon (ircd).
 * (C) 2000-2005 the RageIRCd Development Team, all rights reserved.
 *
 * This software is free, licensed under the General Public License.
 * Please refer to doc/LICENSE and doc/README for further details.
 *
 * $Id: m_topic.c,v 1.25.2.2 2005/01/15 23:53:32 amcwilliam Exp $
 */

#include "config.h"
#include "struct.h"
#include "common.h"
#include "sys.h"
#include "numeric.h"
#include "msg.h"
#include "channel.h"
#include "h.h"
#include "memory.h"
#include "modules.h"
#include <time.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>

Module MOD_HEADER(m_topic) = {
	"m_topic",
	"/TOPIC command",
	6, "$Revision: 1.25.2.2 $"
};

int MOD_LOAD(m_topic)()
{
	if (register_command(&MOD_HEADER(m_topic), &CMD_TOPIC, m_topic) == NULL) {
		return MOD_FAILURE;
	}
	return MOD_SUCCESS;
}

int MOD_UNLOAD(m_topic)()
{
	return MOD_SUCCESS;
}

/*
 * m_topic
 *	parv[0] = sender prefix
 *	parv[1] = channel name
 */
int m_topic(aClient *cptr, aClient *sptr, int parc, char *parv[])	
{
	aChannel *chptr = NULL;
	char *topic = NULL, *name, *tnick = sptr->name;
	time_t ts = timeofday;
	int member;

	if (parc < 2 || *parv[1] == '\0') {
		send_me_numeric(sptr, ERR_NEEDMOREPARAMS, "TOPIC");
		return 0;
	}

	name = parv[1];
	if ((chptr = find_channel(name, NULL)) == NULL) {
		send_me_numeric(sptr, ERR_NOSUCHCHANNEL, name);
		return 0;
	}

	member = IsMember(sptr, chptr);
	if (parc == 2) {
		if (!member) {
			send_me_numeric(sptr, ERR_NOTONCHANNEL, name);
			return 0;
		}

		if (*chptr->topic == '\0') {
			send_me_numeric(sptr, RPL_NOTOPIC, chptr->chname);
		}
		else {
			send_me_numeric(sptr, RPL_TOPIC, chptr->chname, chptr->topic);
			send_me_numeric(sptr, RPL_TOPICWHOTIME, chptr->chname,
				chptr->topic_nick, chptr->topic_time);
		}
		return 0;
	}
	if (!member && !IsServer(cptr) && !IsULine(sptr)) {
		send_me_numeric(sptr, ERR_NOTONCHANNEL, name);
		return 0;
	}
	if (parc > 3 && (!MyConnect(sptr) || IsULine(sptr) || IsServer(sptr))) {
		topic = parc > 4 ? parv[4] : "";
		tnick = parv[2];
		ts = atoi(parv[3]);
	}
	else {
		topic = parv[2];
	}
	if (((!(chptr->mode.mode & CMODE_TOPICLIMIT) || is_chanop(sptr, chptr) || is_halfop(sptr, chptr))
	  || IsULine(sptr) || IsServer(cptr))) {
		if (IsServer(cptr) && !IsULine(sptr) && (chptr->topic_time >= ts) && (*chptr->topic != '\0')) {
			return 0;
		}

		strncpyzt(chptr->topic, topic, TOPICLEN + 1);
		strcpy(chptr->topic_nick, tnick);
		chptr->topic_time = ts;

		sendto_serv_msg_butone(cptr, sptr, &CMD_TOPIC, "%s %s %lu :%s", chptr->chname,
			chptr->topic_nick, chptr->topic_time, chptr->topic);
		sendto_channel_local_msg_butone(NULL, sptr, chptr, ALL_MEMBERS, &CMD_TOPIC,
			"%s :%s", chptr->chname, chptr->topic);
	}
	else {
		send_me_numeric(sptr, ERR_CHANOPRIVSNEEDED, chptr->chname);
	}
	return 0;
}
