/*
 * RageIRCd: an advanced Internet Relay Chat daemon (ircd).
 * (C) 2000-2005 the RageIRCd Development Team, all rights reserved.
 *
 * This software is free, licensed under the General Public License.
 * Please refer to doc/LICENSE and doc/README for further details.
 *
 * $Id: m_squit.c,v 1.29.2.2 2005/01/15 23:53:33 amcwilliam Exp $
 */

#include "config.h"
#include "struct.h"
#include "common.h"
#include "sys.h"
#include "numeric.h"
#include "msg.h"
#include "channel.h"
#include "h.h"
#include "memory.h"
#include "modules.h"
#include "xmode.h"
#include <time.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>

Module MOD_HEADER(m_squit) = {
	"m_squit",
	"/SQUIT command",
	6, "$Revision: 1.29.2.2 $"
};

int MOD_LOAD(m_squit)()
{
	if (register_command(&MOD_HEADER(m_squit), &CMD_SQUIT, m_squit) == NULL) {
		return MOD_FAILURE;
	}
	return MOD_SUCCESS;
}

int MOD_UNLOAD(m_squit)()
{
	return MOD_SUCCESS;
}

/*
 * m_squit
 *	parv[0] = sender prefix
 *	parv[1] = servername
 *	parv[2] = optional comment
 */
int m_squit(aClient *cptr, aClient *sptr, int parc, char *parv[])
{
	char *server, *comment = (parc > 2) ? parv[2] : sptr->name;
	aClient *acptr = NULL;

	if (!IsServer(sptr) && (MyConnect(sptr) && !HasMode(sptr, UMODE_OPER))) {
		send_me_numericNA(sptr, ERR_NOPRIVILEGES);
		return 0;
	}

	if (parc > 1) {
		server = parv[1];

		if (IsServer(cptr)) {
			acptr = find_server_target(server);
		}
		else {
			for (acptr = client; (acptr = next_client(acptr, server)); acptr = acptr->next) {
				if (IsServer(acptr) || IsMe(acptr)) {
					break;
				}
			}
		}
		if ((acptr != NULL) && IsMe(acptr)) {
			/* Ignore clients SQUITing themselves. */
			if (IsClient(sptr)) {
				return 0;
			}
			
			ASSERT(cptr->localClient != NULL);
			
			acptr = cptr;
			server = cptr->localClient->sockhost;
		}
	}
	else {
		if (IsClient(cptr)) {
			send_me_numeric(sptr, ERR_NEEDMOREPARAMS, "SQUIT");
			return 0;
		}

		ASSERT(cptr->localClient != NULL);

		acptr = cptr;
		server = cptr->localClient->sockhost;
	}
	if (acptr == NULL) {
		send_me_numeric(sptr, ERR_NOSUCHSERVER, server);
		return 0;
	}

	if (MyClient(sptr) && ((MyConnect(acptr) && !OPHasFlag(sptr, OFLAG_LROUTE)) ||
	  (!MyConnect(acptr) && !OPHasFlag(sptr, OFLAG_GROUTE)))) {
		send_me_numericNA(sptr, ERR_NOPRIVILEGES);
		return 0;
	}
	if (MyConnect(acptr)) {
		send_gnotice("Received SQUIT %s from %s (%s)", acptr->name,
			get_client_name(sptr, HIDE_IP), comment);
		sendto_serv_msg_butone(NULL, &me, &CMD_GNOTICE, ":Received SQUIT %s from %s (%s)",
			acptr->name, get_client_name(sptr, HIDE_IP), comment);
		ircdlog(LOG_SERVER, "SQUIT from %s: %s (%s)", parv[0], server, comment);

		if (cptr == sptr) {
			exit_client(&me, acptr, sptr, comment);
			return (cptr == acptr) ? FLUSH_BUFFER : 0;
		}
		return exit_client(&me, acptr, sptr, comment);
	}
	if (sptr->from == acptr->from) {
		sendto_realops_lev(DEBUG_LEV, "Exiting server %s due to upstream SQUIT by %s [%s]",
			acptr->name, sptr->name, comment);
		return exit_client(cptr, acptr, sptr, comment);
	}
	if (!CapUNCONNECT(acptr->from)) {
		sendto_realops_lev(DEBUG_LEV, "Exiting server %s due to non-unconnect server %s [%s]",
			acptr->name, acptr->from->name, comment);
		return exit_client(&me, acptr, sptr, comment);
	}

	sendto_realops_lev(DEBUG_LEV, "Passing along SQUIT for %s by %s [%s]", acptr->name, sptr->name,
		comment);
	sendto_one_client_real(acptr->from, acptr, sptr, &CMD_SQUIT, ":%s", comment);
	return 0;
}
