/*
 * RageIRCd: an advanced Internet Relay Chat daemon (ircd).
 * (C) 2000-2005 the RageIRCd Development Team, all rights reserved.
 *
 * This software is free, licensed under the General Public License.
 * Please refer to doc/LICENSE and doc/README for further details.
 *
 * $Id: m_ison.c,v 1.19.2.2 2005/01/15 23:53:32 amcwilliam Exp $
 */

#include "config.h"
#include "struct.h"
#include "common.h"
#include "sys.h"
#include "numeric.h"
#include "msg.h"
#include "channel.h"
#include "h.h"
#include "memory.h"
#include "modules.h"
#include <time.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>  
#include <string.h>
#include <fcntl.h>

static char buf[BUFSIZE];

Module MOD_HEADER(m_ison) = {
	"m_ison",
	"/ISON command",
	6, "$Revision: 1.19.2.2 $"
};

int MOD_LOAD(m_ison)()
{
	if (register_command(&MOD_HEADER(m_ison), &CMD_ISON, m_ison) == NULL) {
		return MOD_FAILURE;
	}
	return MOD_SUCCESS;
}

int MOD_UNLOAD(m_ison)()
{
	return MOD_SUCCESS;
}

/*
 * m_ison
 *	parv[0] = sender prefix
 *	parv[1] = nickname list
 */
int m_ison(aClient *cptr, aClient *sptr, int parc, char *parv[])
{
	aClient *acptr;
	char *s, **pav = parv, *p = NULL, *t;
	int len = 0, mlen;

	if (parc < 2 || *parv[1] == '\0') {
		send_me_numeric(sptr, ERR_NEEDMOREPARAMS, "ISON");
		return 0;
	}

	mlen = strlen(me.name) + strlen(sptr->name) + 12;
	for (s = strtoken(&p, *++pav, " "); s != NULL; s = strtoken(&p, NULL, " ")) {
		if ((acptr = find_person(s, NULL)) != NULL) {
			if ((strlen(acptr->name) + mlen + 1) < sizeof(buf)) {
				if (len > 0) {
					buf[len++] = ' ';
				}
				for (t = acptr->name; *t != '\0'; t++) {
					buf[len++] = *t;
				}
			}
			else {
				break;
			}
		}
	}
	buf[len] = '\0';

	send_me_numeric(sptr, RPL_ISON, buf);
	return 0;
}
