/*
 * RageIRCd: an advanced Internet Relay Chat daemon (ircd).
 * (C) 2000-2005 the RageIRCd Development Team, all rights reserved.
 *
 * This software is free, licensed under the General Public License.
 * Please refer to doc/LICENSE and doc/README for further details.
 *
 * $Id: m_dalinfo.c,v 1.28.2.2 2005/01/15 23:53:32 amcwilliam Exp $
 */

#include "config.h"
#include "struct.h"
#include "common.h"
#include "sys.h"
#include "numeric.h"
#include "msg.h"
#include "channel.h"
#include "h.h"
#include "memory.h"
#include "modules.h"
#include "xmode.h"
#include <time.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>

Module MOD_HEADER(m_dalinfo) = {
	"m_dalinfo",
	"/DALINFO command",
	6, "$Revision: 1.28.2.2 $"
};

int MOD_LOAD(m_dalinfo)()
{
	if (register_command(&MOD_HEADER(m_dalinfo), &CMD_DALINFO, m_dalinfo) == NULL) {
		return MOD_FAILURE;
	}
	return MOD_SUCCESS;
}

int MOD_UNLOAD(m_dalinfo)()
{
	return MOD_SUCCESS;
}

/*
 * m_dalinfo
 *	parv[0] = sender prefix
 */
int m_dalinfo(aClient *cptr, aClient *sptr, int parc, char *parv[])
{
	char **text;
	static time_t last_used = 0L;

	if (!HasMode(sptr, UMODE_OPER)) {
		if (FloodConfig.pace_wait_simple && (last_used + FloodConfig.pace_wait_simple > timeofday)) {
			send_me_numericNA(sptr, RPL_LOAD2HI);
			return 0;
		}
		else {
			last_used = timeofday;
		}
		if (GeneralConfig.spy_notices && IsPerson(sptr)) {
			sendto_realops_lev(SPY_LEV, "DALINFO requested by %s (%s@%s)", sptr->name,
				sptr->username, MaskedHost(sptr));
		}
	}

	for (text = dalinfotext; *text != NULL; text++) {
		send_me_numeric(sptr, RPL_INFO, *text);
	}
	send_me_numericNA(sptr, RPL_ENDOFINFO);
	return 0;
}
