/*
 * RageIRCd: an advanced Internet Relay Chat daemon (ircd).
 * (C) 2000-2005 the RageIRCd Development Team, all rights reserved.
 *
 * This software is free, licensed under the General Public License.
 * Please refer to doc/LICENSE and doc/README for further details.
 *
 * $Id: user_ban.h,v 1.13.2.1 2004/12/07 03:04:54 pneumatus Exp $
 */

#ifndef __user_ban_include__
#define __user_ban_include__ 

#include "queue.h"

#define UBAN_HASH_SIZE 32749

typedef struct _ban_entry banEntry;
typedef struct _user_ban userBan;
typedef struct _simple_ban simBan;

struct _ban_entry {
	union {
		userBan *u;
		simBan *s;
	} ban;
	LIST_ENTRY(_ban_entry) lp;
};

struct _user_ban {
	char *user;
	char *host;
	struct in_addr ip;
	int bits;
	char *reason;
	time_t timeset;
	time_t duration;
	unsigned int flags;
	banEntry *entry;
};

struct _simple_ban {
	char *mask;
	char *reason;
	time_t timeset;
	time_t duration;
	unsigned int flags;
	banEntry *entry;
};

typedef struct _ban_hash_list ban_hash_list;
typedef struct _ban_list ban_list;

LIST_HEAD(_ban_hash_list, _ban_entry);

struct _ban_list {
	ban_hash_list wild_list;
	ban_hash_list *hash_list;
};

#define BAN_LOCAL		0x0001	/* Local ban such as K:line */
#define BAN_NETWORK		0x0002	/* Network ban such as AutoKill */
#define BAN_TEMPORARY		0x0004	/* Temporary ban to expire */
#define BAN_HASWILDS		0x0008	/* Contains wildcards */

#define UBAN_IPV4		0x0010
#define UBAN_CIDR		0x0020
#define UBAN_CIDRBIG		0x0040
#define UBAN_HOST		0x0080
#define UBAN_WILDUSER		0x0100
#define UBAN_WILDHOST		0x0200

#define SBAN_NICK		0x0400
#define SBAN_GCOS		0x0800
#define SBAN_CHAN		0x1000
#define SBAN_FILE		0x2000

#define BanReason(bn)		(BadPtr(bn->reason) ? DEFAULT_REASON : bn->reason)
#define BanExpired(bn)		((bn->flags & BAN_TEMPORARY) && (bn->timeset + bn->duration) <= timeofday)
#define BanMatchFlags(bn,in,ex)	(((bn->flags & in) == in) && !(bn->flags & ex))
#define BanMatchMask(m1,m2,w)	((w) ? !match(m1, m2) : !mycmp(m1, m2))

extern void init_userban();
extern void userban_free(userBan *);
extern void simban_free(simBan *);

extern userBan *make_userban(char *, char *, char *, time_t);
extern void add_userban(userBan *);
extern void del_userban(userBan *);
extern int user_match_ban(aClient *, userBan *);
extern userBan *user_find_ban(aClient *, unsigned int, unsigned int);
extern userBan *ip_find_ban(struct in_addr *, char *);
extern userBan *find_userban_exact(userBan *, unsigned int);
extern void remove_userbans_match_flags(unsigned int, unsigned int);
extern void report_userbans_match_flags(aClient *, unsigned int, unsigned int);
extern void expire_userbans();

extern simBan *make_simban(char *, char *, time_t, unsigned int);
extern void add_simban(simBan *);
extern void del_simban(simBan *);
extern simBan *find_simban_flags(char *, unsigned int);
extern simBan *find_simban_exact(simBan *);
extern void remove_simbans_match_flags(unsigned int, unsigned int);
extern void remove_simbans_match_mask(unsigned int, char *, int);
extern void report_simbans_match_flags(aClient *, unsigned int, unsigned int);
extern void expire_simbans();
extern void send_simbans(aClient *, unsigned int);

#endif /* __user_ban_include__ */
