\name{plot.ordinal}
\title{Plot Ordinal Objects}
\usage{
plot.ordinal(z,ccov=NULL,main=NULL,xlab=NULL,ylab=NULL,xlim=NULL,
             ylim=NULL,lty=NULL,add=F,axes=F,bty="n",at=NULL,
             touch=F,...)
}
\alias{plot.ordinal}
\description{
  Plots the variables in data object of type \code{ordinal} with class
  \code{repeated} or \code{response}. If the data object contains
  time-constant covaiate(s) (\code{tccov}), a plot can be obtained for
  each level of one discrete covariate.
}
\arguments{
  \item{z}{A data object of class \code{repeated} or \code{response},
    and of type \code{ordinal}.}
  \item{ccov}{The name of a discrete time-constant covariate present in
    the data object of type \code{ordinal}.}
  \item{main}{A main title for the plot.}
  \item{xlab}{A label for the x-axis.}
  \item{ylab}{A label for the y-axis.}
  \item{xlim}{The x limits (min,max) of the plot.}
  \item{ylim}{The y limits (min,max) of the plot.}
  \item{lty}{A vector of integers or character strings specifying the
    line type to be used as the default in plotting lines. For further
    information, see \code{\link{par}}.}
  \item{pch}{A vector of integers or single characters specifying
    symbols to be used as the default in plotting points. For further
    information, see \code{\link{par}}.}
  \item{add}{If TRUE, the graph is added to an existing plot.}
  \item{axes}{If FALSE, axes are not drawn around the plot.}
  \item{bty}{A character string which determined the type of box which
    is drawn about plots. For further information, see
    \code{\link{par}}.}
  \item{at}{The points at which tick-marks are to be drawn. For further
    information, see \code{\link{axis}}.}
  \item{touch}{If TRUE, the x-axis and y-axis will touch each other.}
}
\author{P.J. Lindsey}
\seealso{
  \code{\link{lvna}}, \code{\link{plot.response}},
  \code{\link{plot.repeated}}, \code{\link{restovec}},
  \code{\link{rmna}}, \code{\link{tcctomat}}, \code{\link{tvctomat}}.
}
\examples{
library(ordinal)

#
# Binary data
#
data(cardiac.indiv)

y <- restovec(cardiac.indiv[,1:4],type="ordinal")

cov <- tcctomat(as.matrix(cardiac.indiv[,5:10]))

w <- rmna(y,ccov=cov)

rm(cardiac.indiv,y,cov)

par(mfrow=c(2,3))
plot(w,main="All data.")
plot(w,ccov="sex",add=T)
plot(w,ccov="pmi",add=T)
par(mfrow=c(1,1))

rm(w)

#
# Ordinal data
#
data(tmi2)

y <- restovec(tmi2[,1:4],type="ordinal")

cov <- tcctomat(tmi2[,5],name="distance")

w <- rmna(y,ccov=cov)

rm(tmi2,y,cov)

par(mfrow=c(2,2))
plot(w,main="All data.")
plot.new()
plot(w,ccov="distance",add=T)
par(mfrow=c(1,1))

rm(w)
}
\keyword{hplot}
