# test-jit.R: tests for the R jitter

library(jit)

# constants
GCTORTURE.FLAG <- 0
TRACE.FLAG <- 2 # set so we can see compilation is indeed taking place

options(width=10000)          # for easy comparison of results on different systems
test.failed.global <- NULL    # set to name of first test that fails, if any
na.versus.nan.global <- NULL  # set to name of test if a fail is just a NA versus NaN diff

JIT.FLAG <- 1
source("test-jit-lib.R", echo=TRUE)

JIT.FLAG <- 2
source("test-jit-lib.R", echo=TRUE)

cat("\nTest summary: ")
if (is.null(na.versus.nan.global) && is.null(test.failed.global))
    cat("all tests passed\n")
if (!is.null(test.failed.global))
    cat("test ", test.failed.global, " (and possibly others) failed\n", sep="")
if (!is.null(na.versus.nan.global))
    cat("NA versus NaN differences in ", na.versus.nan.global,
            " (and possibly others)\n", sep="")
