struct quisk_cFilter {
	double  * dCoefs;	// filter coefficients
	complex * cpxCoefs;	// make the complex coefficients from dCoefs
	complex * cSamples;	// storage for old samples
	complex * ptcSamp;	// next available position in cSamples
	complex * cBuf;		// auxillary buffer for interpolation
	double  * dBuf;		// auxillary buffer for interpolation
	int nBuf;		// dimension of cBuf and dBuf
	int nTaps;		// dimension of dSamples, cSamples, dCoefs and cpxCoefs
	int counter;		// used to count samples for decimation
} ;

struct quisk_dFilter {
	double  * dCoefs;	// filter coefficients
	complex * cpxCoefs;	// make the complex coefficients from dCoefs
	double  * dSamples;	// storage for old samples
	double  * ptdSamp;	// next available position in dSamples
	complex * cBuf;		// auxillary buffer for interpolation
	double  * dBuf;		// auxillary buffer for interpolation
	int nBuf;		// dimension of cBuf and dBuf
	int nTaps;		// dimension of dSamples, cSamples, dCoefs and cpxCoefs
	int counter;		// used to count samples for decimation
} ;

void quisk_filt_cInit(struct quisk_cFilter *, double *, int);
void quisk_filt_dInit(struct quisk_dFilter *, double *, int);
void quisk_filt_tune(struct quisk_dFilter *, double, int);
complex quisk_dC_out(double, struct quisk_dFilter *);
int quisk_cInterpolate(complex *, int, struct quisk_cFilter *, int);
int quisk_cDecimate(complex *, int, struct quisk_cFilter *, int);

extern double quiskMicFilt48Coefs[325];

extern double quiskMicFilt8Coefs[93];

extern double quiskLpFilt48Coefs[144];

extern double quiskFilt12_19Coefs[64];
