/*
 * Copyright (C) 2010 Google Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1.  Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 * 2.  Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE AND ITS CONTRIBUTORS "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL APPLE OR ITS CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef IDBDatabaseException_h
#define IDBDatabaseException_h

#include "PlatformString.h"
#include <wtf/PassRefPtr.h>
#include <wtf/RefCounted.h>

#if ENABLE(INDEXED_DATABASE)

namespace WebCore {

class IDBDatabaseException : public RefCounted<IDBDatabaseException> {
public:
    static PassRefPtr<IDBDatabaseException> create()
    {
        return adoptRef(new IDBDatabaseException());
    }
    ~IDBDatabaseException() { }

    // Keep in sync with what's in the .idl file.
    enum ErrorCode {
        UNKNOWN_ERR = 0,
        NON_TRANSIENT_ERR = 1,
        NOT_FOUND_ERR = 2,
        CONSTRAINT_ERR = 3,
        DATA_ERR = 4,
        NOT_ALLOWED_ERR = 5,
        SERIAL_ERR = 11,
        RECOVERABLE_ERR = 21,
        TRANSIENT_ERR = 31,
        TIMEOUT_ERR = 32,
        DEADLOCK_ERR = 33
    };
   
    unsigned short code() const { return m_code; }
    void setCode(unsigned short value) { m_code = value; }
    String message() const { return m_message; }
    void setMessage(const String& value) { m_message = value; }

private:
    IDBDatabaseException() { }

    unsigned short m_code;
    String m_message;
};

} // namespace WebCore

#endif

#endif // IDBDatabaseException_h
