/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_TIMING)

#include "JSNavigation.h"

#include "Navigation.h"
#include <runtime/JSNumberCell.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSNavigation);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSNavigationTableValues[3] =
{
    { "type", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNavigationType), (intptr_t)0 THUNK_GENERATOR(0) },
    { "redirectCount", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNavigationRedirectCount), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSNavigationTable = { 5, 3, JSNavigationTableValues, 0 };
/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSNavigationPrototypeTableValues[4] =
{
    { "NAVIGATE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNavigationNAVIGATE), (intptr_t)0 THUNK_GENERATOR(0) },
    { "RELOAD", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNavigationRELOAD), (intptr_t)0 THUNK_GENERATOR(0) },
    { "BACK_FORWARD", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNavigationBACK_FORWARD), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSNavigationPrototypeTable = { 8, 7, JSNavigationPrototypeTableValues, 0 };
const ClassInfo JSNavigationPrototype::s_info = { "NavigationPrototype", 0, &JSNavigationPrototypeTable, 0 };

JSObject* JSNavigationPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSNavigation>(exec, globalObject);
}

bool JSNavigationPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSNavigationPrototype, JSObject>(exec, &JSNavigationPrototypeTable, this, propertyName, slot);
}

bool JSNavigationPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSNavigationPrototype, JSObject>(exec, &JSNavigationPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSNavigation::s_info = { "Navigation", 0, &JSNavigationTable, 0 };

JSNavigation::JSNavigation(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<Navigation> impl)
    : DOMObjectWithGlobalPointer(structure, globalObject)
    , m_impl(impl)
{
}

JSNavigation::~JSNavigation()
{
    forgetDOMObject(this, impl());
}

JSObject* JSNavigation::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSNavigationPrototype(globalObject, JSNavigationPrototype::createStructure(globalObject->objectPrototype()));
}

bool JSNavigation::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSNavigation, Base>(exec, &JSNavigationTable, this, propertyName, slot);
}

bool JSNavigation::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSNavigation, Base>(exec, &JSNavigationTable, this, propertyName, descriptor);
}

JSValue jsNavigationType(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSNavigation* castedThis = static_cast<JSNavigation*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Navigation* imp = static_cast<Navigation*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->type());
    return result;
}

JSValue jsNavigationRedirectCount(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSNavigation* castedThis = static_cast<JSNavigation*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Navigation* imp = static_cast<Navigation*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->redirectCount());
    return result;
}

// Constant getters

JSValue jsNavigationNAVIGATE(ExecState* exec, JSValue, const Identifier&)
{
    return jsNumber(exec, static_cast<int>(0));
}

JSValue jsNavigationRELOAD(ExecState* exec, JSValue, const Identifier&)
{
    return jsNumber(exec, static_cast<int>(1));
}

JSValue jsNavigationBACK_FORWARD(ExecState* exec, JSValue, const Identifier&)
{
    return jsNumber(exec, static_cast<int>(2));
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, Navigation* object)
{
    return getDOMObjectWrapper<JSNavigation>(exec, globalObject, object);
}
Navigation* toNavigation(JSC::JSValue value)
{
    return value.inherits(&JSNavigation::s_info) ? static_cast<JSNavigation*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(WEB_TIMING)
