/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSDOMStringMap.h"

#include "AtomicString.h"
#include "DOMStringMap.h"
#include "JSDOMStringMapCustom.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSDOMStringMap);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSDOMStringMapTableValues[2] =
{
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMStringMapConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSDOMStringMapTable = { 2, 1, JSDOMStringMapTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSDOMStringMapConstructorTableValues[1] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSDOMStringMapConstructorTable = { 1, 0, JSDOMStringMapConstructorTableValues, 0 };
class JSDOMStringMapConstructor : public DOMConstructorObject {
public:
    JSDOMStringMapConstructor(JSC::ExecState*, JSDOMGlobalObject*);

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    virtual const JSC::ClassInfo* classInfo() const { return &s_info; }
    static const JSC::ClassInfo s_info;
    static PassRefPtr<JSC::Structure> createStructure(JSC::JSValue prototype)
    {
        return JSC::Structure::create(prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), AnonymousSlotCount);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSDOMStringMapConstructor::s_info = { "DOMStringMapConstructor", 0, &JSDOMStringMapConstructorTable, 0 };

JSDOMStringMapConstructor::JSDOMStringMapConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(JSDOMStringMapConstructor::createStructure(globalObject->objectPrototype()), globalObject)
{
    putDirect(exec->propertyNames().prototype, JSDOMStringMapPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSDOMStringMapConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSDOMStringMapConstructor, DOMObject>(exec, &JSDOMStringMapConstructorTable, this, propertyName, slot);
}

bool JSDOMStringMapConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSDOMStringMapConstructor, DOMObject>(exec, &JSDOMStringMapConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSDOMStringMapPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSDOMStringMapPrototypeTable = { 1, 0, JSDOMStringMapPrototypeTableValues, 0 };
const ClassInfo JSDOMStringMapPrototype::s_info = { "DOMStringMapPrototype", 0, &JSDOMStringMapPrototypeTable, 0 };

JSObject* JSDOMStringMapPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSDOMStringMap>(exec, globalObject);
}

const ClassInfo JSDOMStringMap::s_info = { "DOMStringMap", 0, &JSDOMStringMapTable, 0 };

JSDOMStringMap::JSDOMStringMap(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<DOMStringMap> impl)
    : DOMObjectWithGlobalPointer(structure, globalObject)
    , m_impl(impl)
{
}

JSDOMStringMap::~JSDOMStringMap()
{
    forgetDOMObject(this, impl());
}

JSObject* JSDOMStringMap::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSDOMStringMapPrototype(globalObject, JSDOMStringMapPrototype::createStructure(globalObject->objectPrototype()));
}

bool JSDOMStringMap::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    const HashEntry* entry = JSDOMStringMapTable.entry(exec, propertyName);
    if (entry) {
        slot.setCustom(this, entry->propertyGetter());
        return true;
    }
    if (canGetItemsForName(exec, static_cast<DOMStringMap*>(impl()), propertyName)) {
        slot.setCustom(this, nameGetter);
        return true;
    }
    return getStaticValueSlot<JSDOMStringMap, Base>(exec, &JSDOMStringMapTable, this, propertyName, slot);
}

bool JSDOMStringMap::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    const HashEntry* entry = JSDOMStringMapTable.entry(exec, propertyName);
    if (entry) {
        PropertySlot slot;
        slot.setCustom(this, entry->propertyGetter());
        descriptor.setDescriptor(slot.getValue(exec, propertyName), entry->attributes());
        return true;
    }
    if (canGetItemsForName(exec, static_cast<DOMStringMap*>(impl()), propertyName)) {
        PropertySlot slot;
        slot.setCustom(this, nameGetter);
        descriptor.setDescriptor(slot.getValue(exec, propertyName), ReadOnly | DontDelete | DontEnum);
        return true;
    }
    return getStaticValueDescriptor<JSDOMStringMap, Base>(exec, &JSDOMStringMapTable, this, propertyName, descriptor);
}

JSValue jsDOMStringMapConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDOMStringMap* domObject = static_cast<JSDOMStringMap*>(asObject(slotBase));
    return JSDOMStringMap::getConstructor(exec, domObject->globalObject());
}
void JSDOMStringMap::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    if (putDelegate(exec, propertyName, value, slot))
        return;
    Base::put(exec, propertyName, value, slot);
}

JSValue JSDOMStringMap::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSDOMStringMapConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, DOMStringMap* object)
{
    return getDOMObjectWrapper<JSDOMStringMap>(exec, globalObject, object);
}
DOMStringMap* toDOMStringMap(JSC::JSValue value)
{
    return value.inherits(&JSDOMStringMap::s_info) ? static_cast<JSDOMStringMap*>(asObject(value))->impl() : 0;
}

}
