/*
 *
 * DeadDiscReader
 * Copyright (C) 2006, Gennady "ShultZ" Kozlov <qpxtool@mail.ru>
 * it uses QPxTool SCSI transport lbrary
 *
 */

#define _FILE_OFFSET_BITS 64

#include <stdio.h>
#include <kbhit.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <qpx_mmc.h>

#include "version.h"
#define	sector_sz	2048

typedef unsigned char mape;
const mape BM_WAIT = 0;
const mape BM_DONE = 1;
const mape BM_FAIL = 2;

#define map_block_sz	16384
typedef mape map_block[map_block_sz];

long fsize(FILE* f){
    struct stat st;
    fstat(fileno(f),&st);
    return st.st_size;
}

class smap {
    public:
	smap(unsigned int sects) {
	    sectors=sects;
	    blocks=(sectors/map_block_sz) + !!(sectors%map_block_sz);
	    arr=(map_block*)malloc(sizeof(map_block)*blocks);
	    fill(BM_WAIT);
	    printf("* map: created for %d sectors\n", sectors);
	}
	~smap() {
	    delete arr;
	}
	mape	get(unsigned int sector) {
	    unsigned int row=sector/map_block_sz;
	    unsigned int col=sector%map_block_sz;
	    return arr[row][col];
	}
	int	get_fail_cnt() {
	    unsigned int cnt=0;
	    for (unsigned int i=0; i<sectors; i++)
		if (get(i) == BM_FAIL) cnt++;
	    return cnt;
	}
	int	get_done_cnt() {
	    unsigned int cnt=0;
	    for (unsigned int i=0; i<sectors; i++)
		if (get(i) == BM_DONE) cnt++;
	    return cnt;
	}
	int	get_wait_cnt() {
	    unsigned int cnt=0;
	    for (unsigned int i=0; i<sectors; i++)
		if (!get(i)) cnt++;
	    return cnt;
	}
	void	set(unsigned int sector, mape state, unsigned int count=0) {
//	    if (sector>sectors) return 1;
//	    if (sector+count>sectors) return 2;
	    if(count) {
		for (unsigned int i=0; i<count; i++) set_one(sector+i, state);
	    } else {
		set_one(sector, state);
	    }
//	    return 0;
	}
	void	set_one(unsigned int sector, mape state) {
	    unsigned int row=sector/map_block_sz;
	    unsigned int col=sector%map_block_sz;
	    arr[row][col]=state;	    
	}
	void	fill(mape state){
	    for (unsigned int i=0; i<blocks; i++)
		for (unsigned int j=0; j<map_block_sz; j++) arr[i][j]=state;
	}
	int	load(char* fn) {
	    FILE* f;
	    int s;
	    map_block	tarr;
	    printf("loading map from file '%s'... ", fn);
	    if (!(f = fopen(fn,"r"))){
		printf("can't open map file!\n");
		return 1;
	    }
	    s=fsize(f);
	    fseek(f, 0, SEEK_SET);
	    for (unsigned i=0; (i<blocks) && (!feof(f)); i++) {
		fread((void*)&tarr, map_block_sz, sizeof(mape), f);
		for (unsigned j=0; (j<map_block_sz) && (i*map_block_sz+j)<(s/sizeof(mape)); j++)
		    set(i*map_block_sz+j, tarr[j]);
	    }
	    fclose(f);
	    printf("done\n");
	    return 0;
	}
	int	save(char* fn) {
	    FILE* f;
	    printf("\nsaving map to file '%s'... ", fn);
	    if (!(f = fopen(fn,"w"))){
		printf("can't create map file!\n");
		return 1;
	    }
	    fseek(f, 0, SEEK_SET);
	    for (unsigned i=0; i<blocks; i++)
		fwrite((void*)arr[i], map_block_sz, sizeof(mape), f);
	    fclose(f);
	    printf("done\n");
	    return 0;
	}
    private:
	unsigned int	sectors;
	unsigned int	blocks;
	map_block*	arr;
};

int read_disc(FILE* f, smap* map, char* n_map, drive_info* dev, int pass){
    int		 lba=0;
    unsigned int step = 1;
    int		 retries=3;

    unsigned int scnt;
    unsigned int x;
    bool	 stop=0;
    bool	 skip=1;
    char	 c;
    keyboard	 kb;
    unsigned int bcnt=0;
    int		 ctry=0;
    int		 perr=0;
    switch (pass) {
	case 0:
	    printf("reading entire disc...\n");
	    scnt=16;
	    break;
	case 1:
	    printf("reading incomplete blocks...\n");
	    scnt=16;
	    break;
	default:
	    printf("reading corrupted blocks only...\n");
	    scnt=1;
	    break;
    }
    dev->err=0;
    for (;(lba<dev->media.capacity) && (!stop);) {
	    skip=1;
	    switch (pass) {
		case 0:
		case 1:
		    if (!map->get(lba)) skip=0;
		    break;
		default:
//		    if (ctry) lba-=scnt;
		    if (map->get(lba) == BM_FAIL) skip=0;
		    break;
	    }
	    if (!skip) {
		if ((!pass) || (pass==1)) printf("\rLBA: %7d/%7d  ", lba, dev->media.capacity);
		else       printf("LBA: %7d/%7d (%d)...  \n", lba, dev->media.capacity, ctry);
		x = dev->media.capacity - lba;
		if (x<scnt) scnt=x;
		if (perr) {
/*
		    dev->cmd_clear();
		    dev->cmd[0]=MMC_SYNC_CACHE;
		    dev->cmd.transport(NONE, NULL, 0);
		    read(dev,lba, scnt, 0);
*/
		    read(dev,lba, scnt, ctry%2);
		} else {
		    read(dev,lba, scnt, 0);
		}
		if (!dev->err) {
		    map->set(lba, BM_DONE, scnt);
		} else {
		    map->set(lba, BM_FAIL, scnt);
		    if ((dev->err >> 8) == 0x23A) stop=1;
		}
		if (!stop) {
		    switch (pass) {
			case 0:
			case 1:
			    fseeko(f, sector_sz*(long long)lba, SEEK_SET);
			    fwrite((void*)dev->rd_buf, sector_sz*scnt, 1, f);
			    break;
			default:
			    if (!dev->err) {
				fseeko(f, sector_sz*(long long)lba, SEEK_SET);
				fwrite((void*)dev->rd_buf, sector_sz*scnt, 1, f);
				ctry=0;
			    } else {
				ctry++;
			    }
			    break;
		    }
		    bcnt++;
		}
	    }
#if 0
	    perr=dev->err;
            lba+=scnt;
#else
	    if (!dev->err) {
	        lba+=scnt;
	        perr=0;		    
		ctry=0;
//	        printf("LBA: %7d 0\n", lba);
	    } else {
		if (ctry>retries) {
		    ctry=0;
	    	    lba/=step;
	    	    lba*=step;
	    	    lba+=step;
		}
	    	perr=dev->err;
		dev->err=0;
//		printf("LBA: %7d !\n", lba);
	    }
#endif		
//	}
	    for (;kb.kbhit();) {
		c=kb.getch();
		switch (c) {
		    case 'w':
		    case 'W':
			map->save(n_map); break;
	    	    case 'q':
		    case 'Q':
			stop=1; break;
		    default:
			break;
		}
	    }
//	    else if (!(bcnt%(512))) map->save(n_map);
    }
    if (stop) printf("Terminating...\n");
    map->save(n_map);
    printf("\n");
};

int main(int argc, char** argv)
{
    drive_info* dev;
    smap*	map;    
    FILE	*f_img;
//    long	s_img;
    char	n_img[1024], n_map[1024];
//    int		rows=0;
//    map_block	tmap;
    unsigned int  fc, dc, ic;
    bool	rfail=0;
    bool	rcont=0;


    if (argc<3) {
	printf("usage: %s /dev/dvd <image_file>\n", argv[0]);
	return 1;
    }
    if (argc>3) {
	if(!strcmp(argv[3],"-f")) rfail=1;
	if(!strcmp(argv[3],"-i")) rcont=1;
    }
    if (argc>4) {
	if(!strcmp(argv[4],"-f")) rfail=1;
	if(!strcmp(argv[4],"-i")) rcont=1;
    }

    dev = new drive_info(argv[1]);
    inquiry(dev);
    printf("*************************************\n");
    printf("*  Dead Disc Reader v%s (c) Gennady \"ShultZ\" Kozlov *\n", VERSION);
    printf("*************************************\n\n");
    printf(" using device : [%s] %s %s %s\n", dev->device, dev->ven, dev->dev, dev->fw);
    strcpy(n_img, argv[2]);
    strcpy(n_map, argv[2]);
    strcat(n_map, ".smap");
    printf(" image file   : '%s'\n", n_img);
    printf(" bitmap file  : '%s'\n", n_map);
    printf(" 'Q'  - stop reading and exit\n");
    printf(" 'W'  - write current sector map to file\n\n");
    printf("\n");
    dev->silent++;
    detect_capabilities(dev);
//    read_disc_information(dev);
    determine_disc_type(dev);
    printf("media type: %02x\n",dev->media.disc_type);
    if (!dev->media.disc_type & (DISC_CD | DISC_DVD)) {
	printf("no media found!\n");
	exit (1);
    }
    read_capacity(dev);
    dev->silent--;
// open image file...
    printf("capacity: %d\n",dev->media.capacity);

    if (!(f_img = fopen(n_img,"r+"))){
	printf("can't open image file, creating new one!\n");
	if (!(f_img = fopen(n_img,"w+"))){
	    printf("can't create image file!\n");
	    exit (2);
	}
    }
//    printf("sizeof(mape)=%d\n", sizeof(mape));
    map = new smap(dev->media.capacity);
    map->load(n_map);

    ic = map->get_wait_cnt();
    dc = map->get_done_cnt();
    fc = map->get_fail_cnt();
    printf("total      : %d\n",dev->media.capacity);
    printf("done       : %d\n",dc);
    printf("corrupted  : %d\n",fc);
    printf("incomplete : %d\n",ic);
    if (!dc) {
	printf("starting reader: pass 0\n");
	read_disc(f_img, map, n_map, dev, 0);
	ic = map->get_wait_cnt();
        dc = map->get_done_cnt();
        fc = map->get_fail_cnt();
        printf("total      : %d\n",dev->media.capacity);
	printf("done       : %d\n",dc);
        printf("corrupted  : %d\n",fc);
	printf("incomplete : %d\n",ic);
    }
    
    if (ic && (rcont)) {
	printf("starting reader: pass 1\n");
	read_disc(f_img, map, n_map, dev, 1);
	ic = map->get_wait_cnt();
        dc = map->get_done_cnt();
	fc = map->get_fail_cnt();
        printf("total      : %d\n",dev->media.capacity);
	printf("done       : %d\n",dc);
        printf("corrupted  : %d\n",fc);
	printf("incomplete : %d\n",ic);
    }
    if (fc && (rfail)) {
	printf("starting reader: pass 2\n");
	read_disc(f_img, map, n_map, dev, 2);
	printf("recovered  : %d\n",fc - map->get_fail_cnt());
	ic = map->get_wait_cnt();
        dc = map->get_done_cnt();
	fc = map->get_fail_cnt();
	printf("total      : %d\n",dev->media.capacity);
	printf("done       : %d\n",dc);
        printf("corrupted  : %d\n",fc);
        printf("incomplete : %d\n",ic);
    }
    fclose(f_img);
    delete map;    
    delete dev;
    return 0;
}
