# Qemu Launcher is a GUI front-end to QEMU computer emulator.
# Copyright (C) 2004 - 2005, Erik Meitner <emeitner@f2o.org>
# Copyright (C) 2006 - 2007, Linas Žvirblis <0x0007@gmail.com>

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.


# Add the redir rule to the lists of redirs and
# return the new list.(skips if it exists already)
# Args: $new_redir, \@redirs
sub redir_add
{
	my $new_redir = $_[0];
	my @redirs    = @{$_[1]};

	foreach my $redir ( @redirs )
	{
		if ( $redir eq $new_redir )
		{
			return( @redirs );
		}
	}

	push( @redirs, $new_redir);

	return( @redirs );
}

# Removes $redir from redir rules list, returns new list.
# Args: $redir, \@redirs
sub redir_del
{
	my $del_redir  = $_[0];
	my @redirs     = @{$_[1]};
	my @new_redirs = ();

	foreach my $redir ( @redirs )
	{
		if ( $redir ne $del_redir )
		{
			push( @new_redirs, $redir );
		}
	}

	return( @new_redirs );
}

# Changes $old_redir to $new_redir in the GUI
# Pulls list from GUI, makes change in list,
# returns new list.
# Args: $new_redir, $old_redir
sub redir_change
{
	my $new_redir = $_[0];
	my $old_redir = $_[1];

	my @redirs     = redirs_pull();
	my @new_redirs = ();

	foreach my $redir ( @redirs )
	{
		if ( $redir eq $old_redir )
		{
			$redir = $new_redir;
		}

		push( @new_redirs, $redir );
	}

	return( @new_redirs );
}

# Pulls redir rules from GUI and returns list
# Args: none
sub redirs_pull
{
	my $model = $glade_vmconfig->get_widget('treeview_redirs')->get_model();
	my $iter  = $model->get_iter_first();

	my @redirs = ();

	my $proto = undef;
	my $hport = undef;
	my $gip   = undef;
	my $gport = undef;

	while ( $iter )
	{
		$proto = $model->get( $iter, 0 );
		$hport = $model->get( $iter, 1 );
		$gip   = $model->get( $iter, 2 );
		$gport = $model->get( $iter, 3 );

		$iter  = $model->iter_next( $iter );

		push( @redirs, $proto.':'.$hport.':'.$gip.':'.$gport );
	}

	return( @redirs );
}

# Clear the redirs treeview and add the items from \@redirs
# args: \@redirs
sub redirs_push
{
	my $model = $glade_vmconfig->get_widget('treeview_redirs')->get_model();
	my $iter  = $model->get_iter_first();

	my @redirs = @{$_[0]};

	my $proto = undef;
	my $hport = undef;
	my $gip   = undef;
	my $gport = undef;

	redirs_clear();

	foreach my $redir ( @redirs )
	{
		my $listiter = $model->append();

		( $proto, $hport, $gip, $gport ) = split( ':', $redir );

		$model->set( $listiter, 0, $proto,1, $hport, 2, $gip, 3, $gport );
	}

	return(1);
}

sub redirs_clear
{
	my $model = $glade_vmconfig->get_widget('treeview_redirs')->get_model();
	my $iter  = $model->get_iter_first();

	$glade_vmconfig->get_widget('radiobutton_tcpproto')->set_active(1);
	$glade_vmconfig->get_widget('spinbutton_hostport')->set_value(1);
	$glade_vmconfig->get_widget('entry_guestoctet')->set_text('');
	$glade_vmconfig->get_widget('spinbutton_guestport')->set_value(1);

	if ( $iter )
	{
		while( $model->remove( $iter ) )
		{
			NULL;
		}
	}

	return(1);
}

# Get the redir rule that is selected in the treeview
# returns 0 if none selected
# Args: none
sub redir_get_selection
{
	my $treeview = $glade_vmconfig->get_widget('treeview_redirs');
	my $iter = $treeview->get_selection()->get_selected();

	my $proto = undef;
	my $hport = undef;
	my $gip   = undef;
	my $gport = undef;

	if ( $iter )
	{
		$proto = $treeview->get_model()->get( $iter, 0 );
		$hport = $treeview->get_model()->get( $iter, 1 );
		$gip   = $treeview->get_model()->get( $iter, 2 );
		$gport = $treeview->get_model()->get( $iter, 3 );

		return( $proto.':'.$hport.':'.$gip.':'.$gport );
	}
	else
	{
		return(0);
	}
}

# Get the redir rule from the entry widgets.
# Args: none
sub redir_pull_rule
{
	my $gip =
		$glade_vmconfig->get_widget('entry_guestoctet')->get_text();
	my $hport =
		$glade_vmconfig->get_widget('spinbutton_hostport')->get_value_as_int();
	my $gport =
		$glade_vmconfig->get_widget('spinbutton_guestport')->get_value_as_int();
	my $proto = undef;

	if ( $glade_vmconfig->get_widget('radiobutton_tcpproto')->get_active() )
	{
		$proto = 'tcp';
	}
	elsif ( $glade_vmconfig->get_widget('radiobutton_udpproto')->get_active() )
	{
		$proto = 'udp';
	}

	return( $proto.':'.$hport.':'.$gip.':'.$gport );
}

# Set the values from $redir_data in the entry widgets
# Args: $redir_data
sub redir_push_rule
{
	my $redir_data = $_[0];
	my ( $proto, $hport, $gip, $gport ) = split( ':', $redir_data );

	$glade_vmconfig->get_widget('entry_guestoctet')->set_text( $gip );
	$glade_vmconfig->get_widget('spinbutton_hostport')->set_value( $hport );
	$glade_vmconfig->get_widget('spinbutton_guestport')->set_value( $gport );

	if ( $proto eq 'tcp' )
	{
		my $proto =
			$glade_vmconfig->get_widget('radiobutton_tcpproto')->set_active(1);
	}
	elsif ( $proto eq 'udp' )
	{
		my $proto =
			$glade_vmconfig->get_widget('radiobutton_udpproto')->set_active(1);
	}

	return(1);
}

1;
