# Qemu Launcher is a GUI front-end to QEMU computer emulator.
# Copyright (C) 2004 - 2005, Erik Meitner <emeitner@f2o.org>
# Copyright (C) 2006 - 2007, Linas Žvirblis <0x0007@gmail.com>

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.


sub prefer_window_show
{
	if ( ! $glade_prefer )
	{
		$glade_prefer = Gtk2::GladeXML->
			new( $data_dir.'/glade/ql_window_prefer.glade' );
	
		$window_prefer = $glade_prefer->get_widget('window_prefer');
		$window_prefer->set_title( gettext('Preferences').' - '.$app_name );
		$window_prefer->set_transient_for( $window_main );
		prefer_window_widgets();
		prefer_window_signals();
	}

	prefer_push();
	$window_prefer->show();

	return(1);
}

sub prefer_window_widgets
{
	foreach my $item (
		gettext( 'Text and icons' ),
		gettext( 'Icons only' ),
		gettext( 'Text only' )
	)
	{
		$glade_prefer->get_widget('combobox_toolbar')->append_text( $item );
	}

	return(1);
}

sub prefer_window_signals
{
	$window_prefer->
		signal_connect( 'delete_event' => sub
		{
			prefer_pull();
			prefer_save();
			$_[0]->hide();

			return(1);
		} );

	$glade_prefer->get_widget('button_close')->
		signal_connect( 'clicked' => sub
		{
			prefer_pull();
			prefer_save();
			$window_prefer->hide();

			return(1);
		} );

	$glade_prefer->get_widget('combobox_toolbar')->
		signal_connect( 'changed' => sub
		{
			my $selection =
				$tool_val_by_num{ $glade_prefer->get_widget('combobox_toolbar')
					->get_active() };

			$glade_main->get_widget('toolbar_main')->set_style( $selection );

			return(1);
		} );

	return(1);
}

sub prefer_load
{
	%prefer = %prefer_default;

	my $filename = $prefer_dir.'/'.$prefer_file;

	if ( -e $filename )
	{
		my $fh = new IO::File( $filename, 'r' );

		while ( <$fh> )
		{
			next if /^#/;
	
			if ( /\s*([^:]+)\=(.*)$/ )
			{
				$prefer{$1} = $2;
			}
		}

		close( $fh );
	}
	else
	{
		prefer_save();
	}

	return(1);
}

sub prefer_push
{
	if ( $prefer{'action'} eq 'launch' )
	{
		$glade_prefer->get_widget('radiobutton_launch')->set_active(1);
	}
	elsif ( $prefer{'action'} eq 'edit' )
	{
		$glade_prefer->get_widget('radiobutton_edit')->set_active(1);
	}

	$glade_prefer->get_widget('combobox_toolbar')->
		set_active( $tool_val_by_txt{$prefer{'toolbar'}} );

	$glade_prefer->get_widget('dirchooser_datadir')->set_filename( $prefer{'datadir'} );

	return(1);
}

sub prefer_pull
{
	if ( $glade_prefer->get_widget('radiobutton_launch')->get_active() )
	{
		$prefer{'action'} = 'launch';
	}
	elsif ( $glade_prefer->get_widget('radiobutton_edit')->get_active() )
	{
		$prefer{'action'} = 'edit';
	}

	$prefer{'toolbar'} = $tool_val_by_num{ $glade_prefer->
		get_widget('combobox_toolbar')->get_active() };

	$prefer{datadir} = $glade_prefer->get_widget('dirchooser_datadir')->
		get_filename();

	return(1);
}

sub prefer_save
{
	my $var = undef;

	if ( ! -d $prefer_dir )
	{
		mkdir( $prefer_dir );
	}

	my $filename = $prefer_dir.'/'.$prefer_file;
	my $fh = new IO::File( $filename, 'w' );

	if ( ! $fh )
	{
		#alert_user( sprintf(gettext("Could not save configuration to %s"), $filename) );
		return(0);
	}

	foreach $var ( keys %prefer )
	{
		if ( $prefer{$var} eq '' )
		{
			print( $fh $var.'='.'null'."\n" );
		}
		else
		{
			print( $fh $var.'='.$prefer{$var}."\n" );
		}
	}

	close( $fh );

	return(1);
}

1;
