# Qemu Launcher is a GUI front-end to QEMU computer emulator.
# Copyright (C) 2004 - 2005, Erik Meitner <emeitner@f2o.org>
# Copyright (C) 2006 - 2007, Linas Žvirblis <0x0007@gmail.com>

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.


sub misc_timestamp
{
	my ( $sec, $min, $hour, $mday, $mon,
		$year, $wday, $yday, $isdst ) = localtime(time);
	return( sprintf( "%4d%02d%02d%02d%02d%02d",
		$year+1900, $mon+1, $mday, $hour, $min, $sec ) );
}

sub misc_activate_gui
{
	my $widget = undef;
	my $state  = $_[0];

	foreach $widget (
		'toggletoolbutton_edit',
		'toolbutton_delete',
		'toolbutton_launch',
		'menuitem_edit',
		'menuitem_delete',
		'menuitem_launch'
	)
	{
		$glade_main->get_widget($widget)->set_sensitive( $state );
	}

	return(1);
}

sub misc_nic_visible
{
	my ( $idx, @bits ) = @_;

	if ( $bits[0] )
	{
		$glade_vmconfig->get_widget('hbox_netmac'.$idx)->show();
		$glade_vmconfig->get_widget('hseparator_netmac'.$idx)->show();
	}
	else
	{
		$glade_vmconfig->get_widget('hbox_netmac'.$idx)->hide();
		$glade_vmconfig->get_widget('hseparator_netmac'.$idx)->hide();
	}

	if ( $bits[1] )
	{
		$glade_vmconfig->get_widget('hbox_netip'.$idx)->show();
		$glade_vmconfig->get_widget('hseparator_netip'.$idx)->show();
	}
	else
	{
		$glade_vmconfig->get_widget('hbox_netip'.$idx)->hide();
		$glade_vmconfig->get_widget('hseparator_netip'.$idx)->hide();
	}

	if ( $bits[2] )
	{
		$glade_vmconfig->get_widget('hbox_tapscript'.$idx)->show();
		$glade_vmconfig->get_widget('hseparator_tapscript'.$idx)->show();
	}
	else
	{
		$glade_vmconfig->get_widget('hbox_tapscript'.$idx)->hide();
		$glade_vmconfig->get_widget('hseparator_tapscript'.$idx)->hide();
	}

	if ( $bits[3] )
	{
		$glade_vmconfig->get_widget('hbox_netname'.$idx)->show();
		$glade_vmconfig->get_widget('hseparator_netname'.$idx)->show();
	}
	else
	{
		$glade_vmconfig->get_widget('hbox_netname'.$idx)->hide();
		$glade_vmconfig->get_widget('hseparator_netname'.$idx)->hide();
	}

	if ( $bits[4] )
	{
		$glade_vmconfig->get_widget('hbox_netfd'.$idx)->show();
		$glade_vmconfig->get_widget('hseparator_netfd'.$idx)->show();
	}
	else
	{
		$glade_vmconfig->get_widget('hbox_netfd'.$idx)->hide();
		$glade_vmconfig->get_widget('hseparator_netfd'.$idx)->hide();
	}

	return(1);
}

sub misc_diskimg_sensitive
{
	my @bits = @_;

	$glade_diskimg->get_widget('chooser_source')->set_sensitive( $bits[0] );
	$glade_diskimg->get_widget('spinbutton_size')->set_sensitive( $bits[1] );
	$glade_diskimg->get_widget('combobox_units')->set_sensitive( $bits[2] );

	return(1);
}

sub detect_apps_main
{
	my $output = undef;

	for ( $idx = 0; $idx < scalar(@apps_main); $idx++ )
	{
		$output = `which $apps_main[$idx]`;
		$output =~ s/\s+$//;

		if ( $output )
		{
			$apps{$apps_main[$idx]} = $output;
		}
		else
		{
			dialog_alert(
				sprintf( gettext("Could not detect binary for '%s'"), $apps_main[$idx] ),
				gettext( "Make sure it is properly installed" ),
				'error',
				undef
			);

			return(0);
		}
	}

	return(1);
}

sub detect_apps_extra
{
	my $output = undef;

	for ( $idx = 0; $idx < scalar(@apps_extra); $idx++ )
	{
		$output = `which $apps_extra[$idx]`;
		$output =~ s/\s+$//;

		if ( $output )
		{
			$apps{$apps_extra[$idx]} = $output;
		}
	}

	$idx = 1;
	foreach my $item ( @apps_extra )
	{
		if ( $item and $apps{$item} and ( $item ne 'kvm') )
		{
			$sys_val_by_num{$idx} = $arch_by_emu{$item};
			$sys_val_by_txt{$arch_by_emu{$item}} = $idx;
			$idx++;
		}
	}

	return(1);
}

1;
