# Qemu Launcher is a GUI front-end to QEMU computer emulator.
# Copyright (C) 2004 - 2005, Erik Meitner <emeitner@f2o.org>
# Copyright (C) 2006 - 2007, Linas Žvirblis <0x0007@gmail.com>

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.


# Display main window
# Args: none.
# Returns: 1.
sub main_window_show
{
	# Main window
	$window_main = $glade_main->get_widget('window_main');
	$window_main->set_title( $app_name );
	$window_main->set_default_size( $window_main_w, $window_main_h );
	$window_main->resize( $window_main_w, $window_main_h );
	$window_main->signal_connect( 'delete_event' => \&app_quit );

	# Toolbar
	$glade_main->get_widget('toolbar_main')->set_style( $prefer{'toolbar'} );

	# VM list in main window
	my $column0 = Gtk2::TreeViewColumn->
		new_with_attributes(
			"",
			Gtk2::CellRendererPixbuf->new(),
			"pixbuf",
			0 );

	my $column1 = Gtk2::TreeViewColumn->
		new_with_attributes(
			"",
			Gtk2::CellRendererText->new(),
			"markup",
			1 );

	my $liststore = Gtk2::ListStore->new(
		'Gtk2::Gdk::Pixbuf',
		'Glib::String',
		'Glib::String' );

	$treeview_main = $glade_main->get_widget('treeview_main');
	$treeview_main->set_model($liststore);
	$treeview_main->append_column($column0);
	$treeview_main->append_column($column1);

	return(1);
}

# Set signal handlers
sub main_window_signals
{
	# Toolbar buttons
	$glade_main->get_widget('toolbutton_new')->
		signal_connect( 'clicked' => sub
		{
			vmconfig_new();
		} );
	$glade_main->get_widget('toggletoolbutton_edit')->
		signal_connect( 'toggled' => sub
		{
			vmconfig_edit();
		} );
	$glade_main->get_widget('toolbutton_delete')->
		signal_connect( 'clicked' => sub
		{
			vmconfig_delete();
		} );
	$glade_main->get_widget('toolbutton_launch')->
		signal_connect( 'clicked' => sub
		{
			my $item = vmconfig_getselection();

			if ( $glade_main->get_widget('toggletoolbutton_edit')->get_active() )
			{
				vmconfig_pull();
				vmconfig_save( $item );
				vmconfig_populate();
				vmconfig_select( $item );
			}

			vmconfig_launch( $item );
		} );
	$glade_main->get_widget('toolbutton_disk_images')->
		signal_connect( 'clicked' => sub
		{
			diskimg_window_show();
		} );
	$glade_main->get_widget('toolbutton_preferences')->
		signal_connect( 'clicked' => sub
		{
			prefer_window_show();
		} );

	# Menubar items
	$glade_main->get_widget('menuitem_new')->
		signal_connect( 'activate' => sub
		{
			vmconfig_new();
		} );
	$glade_main->get_widget('menuitem_edit')->
		signal_connect( 'activate' => sub
		{
			$glade_main->get_widget('toggletoolbutton_edit')->set_active(1);
			vmconfig_edit();
		} );
	$glade_main->get_widget('menuitem_delete')->
		signal_connect( 'activate' => sub
		{
			vmconfig_delete();
		} );
	$glade_main->get_widget('menuitem_launch')->
		signal_connect( 'activate' => sub
		{
			vmconfig_launch();
		} );
	$glade_main->get_widget('menuitem_quit')->
		signal_connect( 'activate' => sub
		{
			app_quit();
		} );
	$glade_main->get_widget('menuitem_diskimg')->
		signal_connect( 'activate' => sub
		{
			diskimg_window_show();
		} );
	$glade_main->get_widget('menuitem_preferences')->
		signal_connect( 'activate' => sub
		{
			prefer_window_show();
		} );
	$glade_main->get_widget('menuitem_about')->
		signal_connect( 'activate' => sub
		{
			dialog_about();
		} );

	# Tree view
	$glade_main->get_widget('treeview_main')->
		signal_connect( 'row-activated' => sub
		{
			if ( $prefer{'action'} eq 'launch' )
			{
				vmconfig_launch();
			}
			elsif ( $prefer{'action'} eq 'edit' )
			{
				$glade_main->get_widget('toggletoolbutton_edit')->set_active(1);
				#vmconfig_edit();
			}

			return(1);
		} );

	$glade_main->get_widget('treeview_main')->get_selection()->
		signal_connect( 'changed' => sub
		{
			my $item = vmconfig_getselection();

			if (
				$item and
				$glade_vmconfig and
				$glade_main->get_widget('toggletoolbutton_edit')->get_active()
			)
			{
				vmconfig_window_show( $vmconfig_cache{$item}{'name'} );
				vmconfig_push( $vmconfig_current );
			}

			return(1);
		} );

	return(1);
}

1;
