# Qemu Launcher is a GUI front-end to QEMU computer emulator.
# Copyright (C) 2004 - 2005, Erik Meitner <emeitner@f2o.org>
# Copyright (C) 2006 - 2007, Linas Žvirblis <0x0007@gmail.com>

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.


sub diskimg_window_show
{
	my $drive = $_[0];

	if ( ! $glade_diskimg )
	{
		$glade_diskimg = Gtk2::GladeXML->
			new( $data_dir.'/glade/ql_window_diskimg.glade' );
	
		$window_diskimg = $glade_diskimg->get_widget('window_diskimg');
		$window_diskimg->set_title( gettext('New disk image'.' - '.$app_name ) );
		diskimg_window_widgets();
		diskimg_window_signals();
	}

	diskimg_push( $drive );
	$window_diskimg->show();

	return(1);
}

sub diskimg_window_widgets
{
	foreach my $item (
		gettext( 'KiB' ),
		gettext( 'MiB' ),
		gettext( 'GiB' )
	)
	{
		$glade_diskimg->get_widget('combobox_units')->append_text( $item );
	}

	$glade_diskimg->get_widget('combobox_units')->set_active(1);

	return(1);
}

sub diskimg_window_signals
{
	$window_diskimg->
		signal_connect( 'delete_event' => sub
		{
			$_[0]->hide();

			return(1);
		} );

	$glade_diskimg->get_widget('button_cancel')->
		signal_connect( 'clicked' => sub
		{
			$window_diskimg->hide();

			return(1);
		} );

	$glade_diskimg->get_widget('button_save')->
		signal_connect( 'clicked' => sub
		{
			diskimg_save();
			$window_diskimg->hide();

			return(1);
		} );

	$glade_diskimg->get_widget('radiobutton_qcow')->
		signal_connect( 'clicked' => sub
		{
			misc_diskimg_sensitive( 0, 1, 1 );

			return(1);
		} );

	$glade_diskimg->get_widget('radiobutton_raw')->
		signal_connect( 'clicked' => sub
		{
			misc_diskimg_sensitive( 0, 1, 1 );

			return(1);
		} );

	$glade_diskimg->get_widget('radiobutton_dev')->
		signal_connect( 'clicked' => sub
		{
			misc_diskimg_sensitive( 1, 0, 0 );

			return(1);
		} );

	return(1);
}

sub diskimg_push
{
	my $drive = $_[0];

	if ( ! $drive )
	{
		$glade_diskimg->get_widget('radiobutton_qcow')->set_active(1);

		$glade_diskimg->get_widget('chooser_source')->set_sensitive(0);
		$glade_diskimg->get_widget('chooser_source')->unselect_all();
	}
	elsif (
		( $drive eq 'fda' ) or
		( $drive eq 'fdb' )
	)
	{
		$glade_diskimg->get_widget('radiobutton_dev')->set_active(1);

		$glade_diskimg->get_widget('chooser_source')->set_sensitive(1);
		$glade_diskimg->get_widget('chooser_source')->set_filename('/dev/fd0');
	}
	elsif (
		( $drive eq 'hda' ) or
		( $drive eq 'hdb' ) or
		( $drive eq 'hdc' ) or
		( $drive eq 'hdd' )
	)
	{
		$glade_diskimg->get_widget('radiobutton_qcow')->set_active(1);

		$glade_diskimg->get_widget('chooser_source')->set_sensitive(0);
		$glade_diskimg->get_widget('chooser_source')->unselect_all();
	}
	elsif ( $drive eq 'cdrom' )
	{
		$glade_diskimg->get_widget('radiobutton_dev')->set_active(1);

		$glade_diskimg->get_widget('chooser_source')->set_sensitive(1);
		$glade_diskimg->get_widget('chooser_source')->set_filename('/dev/cdrom');
	}

	$diskimg_drive = $drive;

	return(1);
}

sub diskimg_save
{
	my $source =
		$glade_diskimg->get_widget('chooser_source')->get_filename();
	my $size =
		$glade_diskimg->get_widget('spinbutton_size')->get_value_as_int();
	my $units =
		$glade_diskimg->get_widget('combobox_units')->get_active();
	my $filename = dialog_save();

	if ( $filename )
	{
		if ( $glade_diskimg->get_widget('radiobutton_qcow')->get_active() )
		{
			if ( $units == 0 )
			{
				system( $apps{'qemu-img'}.' create -f qcow "'.$filename.'" '.$size );
			}
			elsif ( $units == 1 )
			{
				system( $apps{'qemu-img'}.' create -f qcow "'.$filename.'" '.$size.'M' );
			}
			elsif ( $units == 2 )
			{
				system( $apps{'qemu-img'}.' create -f qcow "'.$filename.'" '.$size.'G' );
			}
		}
		elsif ( $glade_diskimg->get_widget('radiobutton_raw')->get_active() )
		{
			if ( $units == 0 )
			{
				system( $apps{'qemu-img'}.' create -f raw "'.$filename.'" '.$size );
			}
			elsif ( $units == 1 )
			{
				system( $apps{'qemu-img'}.' create -f raw "'.$filename.'" '.$size.'M' );
			}
			elsif ( $units == 2 )
			{
				system( $apps{'qemu-img'}.' create -f raw "'.$filename.'" '.$size.'G' );
			}
		}
		elsif ( $glade_diskimg->get_widget('radiobutton_dev')->get_active() )
		{
			system( $apps{'dd'}.' if='.$source.' of='.$filename );
		}

		if ( ( $diskimg_drive ) and ( -e $filename ) )
		{
			$glade_vmconfig->
				get_widget('chooser_'.$diskimg_drive)->
					set_filename( $filename );
		}
	}

	return(1);
}

1;
