# Qemu Launcher is a GUI front-end to QEMU computer emulator.
# Copyright (C) 2004 - 2005, Erik Meitner <emeitner@f2o.org>
# Copyright (C) 2006 - 2007, Linas Žvirblis <0x0007@gmail.com>

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.


# Display about dialog.
# Args: none, reads global.
# Returns: 1/0.
sub dialog_about
{
	my $dialog = Gtk2::AboutDialog->new();

	$dialog->set_logo( $icon_default );
	$dialog->set_name( $app_name );
	$dialog->set_version( $app_version );
	$dialog->set_comments( gettext(sprintf("%s is a GUI front-end to QEMU computer emulator.", $app_name)) );
	$dialog->set_copyright(
		gettext('Copyright (C)')." 2004 - 2005, Erik Meitner <emeitner\@f2o.org>".
		"\n".
		gettext('Copyright (C)')." 2006 - 2007, Linas Žvirblis <0x0007\@gmail.com>".
		"\n".
		gettext("QEMU is a trademark of Fabrice Bellard")
	);

	$dialog->set_authors(
		"Erik Meitner",
		"Linas Žvirblis"
	);

#	$dialog->set_translator_credits(
#		"Linas Žvirblis ".gettext("(Lithuanian)")
#	);

	$dialog->set_license(
		gettext("This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any later version.").
		"\n\n".
		gettext("This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.")
	);

	$dialog->set_wrap_license(1);
	$dialog->set_transient_for( $window_main );

	if ( $dialog->run() )
	{
		$dialog->destroy();
		return(1);
	}
	else
	{
		$dialog->destroy();
		return(0);
	}
}

# As for a name for a new configuration.
# Args: none.
# Returns: name or 0.
sub dialog_vmname
{
	my $vmname = undef;

	my $dialog = Gtk2::Dialog->new(
		gettext('New configuration').' - '.$app_name,
		$window_main,
		'modal',
		'gtk-cancel' => 'GTK_RESPONSE_CANCEL',
		'gtk-new' => 'GTK_RESPONSE_OK'
	);

	my $hbox  = Gtk2::HBox->new( 0, 4 );
	my $entry = Gtk2::Entry->new();

	$dialog->vbox->pack_start( $hbox, 0, 0, 6 );
	$hbox->pack_start( Gtk2::Label->new(gettext('Name:')), 0, 1, 0 );
	$hbox->pack_start( $entry, 1, 1, 0 );

	$hbox->set_border_width(8);
	$entry->set_width_chars(25);
	$dialog->set_transient_for( $window_main );
	$dialog->show_all();

	if ( $dialog->run() eq 'ok' )
	{
		$vmname = $entry->get_text();
		$dialog->destroy();
		return( $vmname );
	}
	else
	{
		$dialog->destroy();
		return(0);
	}
}

# Ask user a question.
# Args: message (string), detailed explanaion (string), type of OK button
# (string), parent window (GTK window).
# Returns: 1/0.
sub dialog_question
{
	my $message = $_[0];
	my $reason  = $_[1];
	my $button  = $_[2];
	my $parent  = $_[3];

	my $dialog = Gtk2::Dialog->new(
		gettext('Qestion').' - '.$app_name,
		$parent,
		'modal',
		'gtk-cancel' => 'GTK_RESPONSE_CANCEL',
		$button => 'GTK_RESPONSE_OK'
	);

	my $hbox  = Gtk2::HBox->new( 0, 0 );
	my $vbox = Gtk2::VBox->new( 0, 0 );
	my $label_message = Gtk2::Label->new( '<b>'.$message.'</b>' );
	my $label_reason = Gtk2::Label->new( $reason );

	$dialog->vbox->pack_start( $hbox, 1, 0, 0 );
	$hbox->pack_start( Gtk2::Image->
		new_from_stock('gtk-dialog-question', 'dialog'), 0, 1, 4 );
	$hbox->pack_start( $vbox, 1, 1, 4 );
	$vbox->pack_start( $label_message, 1, 1, 0 );
	$vbox->pack_start( $label_reason, 1, 1, 0 );

	$hbox->set_border_width(8);
	$label_message->set_use_markup(1);
	$dialog->set_transient_for( $parent );
	$dialog->show_all();

	if ( $dialog->run() eq 'ok' )
	{
		$dialog->destroy();
		return(1);
	}
	else
	{
		$dialog->destroy();
		return(0);
	}
}

# Display error or warning message.
# Args: message (string), detailed explanaion (string), warning or error
# (string), parent window (GTK window).
# Returns: 1/0.
sub dialog_alert
{
	my $title = undef;

	my $message = $_[0];
	my $reason  = $_[1];
	my $type    = $_[2];
	my $parent  = $_[3];

	if ( $type eq 'warning' )
	{
		$title = gettext( 'Warning' );
	}
	elsif ( $type eq 'error' )
	{
		$title = gettext( 'Error!' );
	}

	my $dialog = Gtk2::Dialog->new(
		$title.' - '.$app_name,
		$parent,
		'modal',
		'gtk-close' => 'GTK_RESPONSE_OK'
	);

	my $hbox = Gtk2::HBox->new( 0, 0 );
	my $vbox = Gtk2::VBox->new( 0, 0 );

	my $label_message = Gtk2::Label->new( '<b>'.$message.'</b>' );
	my $label_reason  = Gtk2::Label->new( $reason );

	$dialog->vbox->pack_start( $hbox, 1, 0, 0 );
	$hbox->pack_start( Gtk2::Image->
		new_from_stock('gtk-dialog-'.$type, 'dialog'), 0, 1, 4 );
	$hbox->pack_start( $vbox, 1, 1, 4 );
	$vbox->pack_start( $label_message, 1, 1, 0 );
	$vbox->pack_start( $label_reason, 1, 1, 0 );

	$hbox->set_border_width(8);
	$label_message->set_use_markup(1);
	$dialog->set_transient_for( $parent );
	$dialog->show_all();

	if ( $dialog->run() )
	{
		$dialog->destroy();
		return(1);
	}
	else
	{
		$dialog->destroy();
		return(0);
	}
}

sub dialog_save
{
	my $chooser = Gtk2::FileChooserDialog->new(
		gettext( 'Save image as...' ),
		$parent,
		'GTK_FILE_CHOOSER_ACTION_SAVE',
		'gtk-cancel' => 'GTK_RESPONSE_CANCEL',
		'gtk-save' => 'GTK_RESPONSE_OK'
	);

	$chooser->set_current_folder( $prefer{'datadir'} );

	if ( $chooser->run() eq 'ok' )
	{
		$selection = $chooser->get_filename();
		$chooser->destroy();
		return( $selection );
	}
	else
	{
		$chooser->destroy();
		return(0);
	}
}

1;
