/***************************************************************************
                          spl_prg.cpp  -  description
                             -------------------
    begin                : Fri Jan 21 2005
    copyright            : (C) 2005 by Harald Krippel
    email                : neuro.harald@surfeu.at
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   this program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "spl_prg.hpp"
#include <main.h>
#include "scripting.hpp"
#include "scriptprg.hpp"
#include "messages.hpp"


void spl_qt_reportfunc(int type, void *desc, const char *fmt, ...)
{
    va_list ap;

    va_start(ap, fmt);
    char *msg = spl_report_string(type, desc, fmt, ap);
    va_end(ap);
    QString qmsg = (const char*)msg;
    free(msg);
    msg=0;
    ErrorMsg errormsg(qmsg);
//    qWarning(qmsg.toAscii());  // debug
}

static void *qcakespl_malloc_file(const char *filename, int *size)
{
   QString qcfileName = filename;
   QFile file(qcfileName);
   if(QFileInfo(file).isAbsolute ()){
      return spl_malloc_file(filename,size);
   }else{
      QString qcfileName = g_prjpath + "/" +filename;
      return spl_malloc_file(qcfileName.toAscii(),size);
   }
}

//******spl_node****************************************************

static struct spl_node *my_getPositionX ( struct spl_task *task, void *data )
{
  if ( spl_clib_get_argc(task) != 1 ){
    spl_report(SPL_REPORT_RUNTIME, task, "getPositionX: Parameter must be a int !\n");
    ((splPrg *)data)->TurnOff();
    return 0 ;
  } else {
    int hh= spl_clib_get_int(task);
    return SPL_NEW_FLOAT(((splPrg *)data)->ScriptApi->getPositionX(hh));
  }
}

static struct spl_node *my_getPositionY ( struct spl_task *task, void *data )
{
  if ( spl_clib_get_argc(task) != 1 ){
    spl_report(SPL_REPORT_RUNTIME, task, "getPositionY: Parameter must be a int !\n");
    ((splPrg *)data)->TurnOff();
    return 0 ;
  } else {
    int hh= spl_clib_get_int(task);
    return SPL_NEW_FLOAT(((splPrg *)data)->ScriptApi->getPositionY(hh));
  }
}

static struct spl_node *my_getPositionZ ( struct spl_task *task, void *data )
{
  if ( spl_clib_get_argc(task) != 1 ){
    spl_report(SPL_REPORT_RUNTIME, task, "getPositionZ: Parameter must be a int !\n");
    ((splPrg *)data)->TurnOff();
    return 0 ;
  } else {
    int hh= spl_clib_get_int(task);
    return SPL_NEW_FLOAT(((splPrg *)data)->ScriptApi->getPositionZ(hh));
  }
}

static struct spl_node *my_getPositionH ( struct spl_task *task, void *data )
{
  if ( spl_clib_get_argc(task) != 1 ){
    spl_report(SPL_REPORT_RUNTIME, task, "getPositionH: Parameter must be a int !\n");
    ((splPrg *)data)->TurnOff();
    return 0 ;
  } else {
    int hh= spl_clib_get_int(task);
    return SPL_NEW_FLOAT(((splPrg *)data)->ScriptApi->getPositionH(hh));
  }
}
static struct spl_node *my_getPositionP ( struct spl_task *task, void *data )
{
  if ( spl_clib_get_argc(task) != 1 ){
    spl_report(SPL_REPORT_RUNTIME, task, "getPositionP: Parameter must be a int !\n");
    ((splPrg *)data)->TurnOff();
    return 0 ;
  } else {
    int hh= spl_clib_get_int(task);
    return SPL_NEW_FLOAT(((splPrg *)data)->ScriptApi->getPositionP(hh));
  }
}
static struct spl_node *my_getPositionR ( struct spl_task *task, void *data )
{
  if ( spl_clib_get_argc(task) != 1 ){
    spl_report(SPL_REPORT_RUNTIME, task, "getPositionR: Parameter must be a int !\n");
    ((splPrg *)data)->TurnOff();
    return 0 ;
  } else {
    int hh= spl_clib_get_int(task);
    return SPL_NEW_FLOAT(((splPrg *)data)->ScriptApi->getPositionR(hh));
  }
}

static struct spl_node *my_addRelTorque ( struct spl_task *task, void *data )
{
  if ( spl_clib_get_argc(task) != 4 ){
    spl_report(SPL_REPORT_RUNTIME, task,"addRelTorque: Parameter must be a int, float, float, float !\n" ) ;
    ((splPrg *)data)->TurnOff();
    return 0 ;
  } else {
   // hh,velx,vely,velz
   int hh= spl_clib_get_int(task);
   float velx= spl_clib_get_float(task);
   float vely= spl_clib_get_float(task);
   float velz= spl_clib_get_float(task);

   ((splPrg *)data)->ScriptApi->addRelTorque ( hh,velx,vely,velz );
   return 0 ;
  }
}

static struct spl_node *my_setAngularVel ( struct spl_task *task, void *data )
{
  if ( spl_clib_get_argc(task) != 4 ){
    spl_report(SPL_REPORT_RUNTIME, task,"setAngularVel: Parameter must be a int, float, float, float !\n" ) ;
    ((splPrg *)data)->TurnOff();
    return 0 ;
  } else {
   // hh,velx,vely,velz
   int hh= spl_clib_get_int(task);
   float velx= spl_clib_get_float(task);
   float vely= spl_clib_get_float(task);
   float velz= spl_clib_get_float(task);

   ((splPrg *)data)->ScriptApi->setAngularVel ( hh,velx,vely,velz ) ;
   return 0 ;
  }
}

static struct spl_node *my_addRelForce ( struct spl_task *task, void *data )
{
  if ( spl_clib_get_argc(task) != 4 ){
    spl_report(SPL_REPORT_RUNTIME, task,"addRelForce: Parameter must be a int, float, float, float !\n" ) ;
    ((splPrg *)data)->TurnOff();
    return 0 ;
  } else {
   // hh,velx,vely,velz
   int hh= spl_clib_get_int(task);
   float velx= spl_clib_get_float(task);
   float vely= spl_clib_get_float(task);
   float velz= spl_clib_get_float(task);

   ((splPrg *)data)->ScriptApi->addRelForce ( hh,velx,vely,velz ) ;
   return 0 ;
  }
}

static struct spl_node *my_setSequence ( struct spl_task *task, void *data )
{
  if ( spl_clib_get_argc(task) != 3 ){
    spl_report(SPL_REPORT_RUNTIME, task,"setLinVel: Parameter must be a int, int, int!\n" ) ;
    ((splPrg *)data)->TurnOff();
    return 0 ;
  } else {
   // hh,sequenz,mode
   int hh= spl_clib_get_int(task);
   int sequence= spl_clib_get_int(task);
   int mode= spl_clib_get_int(task);

   ((splPrg *)data)->ScriptApi->setSequence ( hh,sequence,mode ) ;
   return 0 ;
  }
}

static struct spl_node *my_setLinVel ( struct spl_task *task, void *data )
{
  if ( spl_clib_get_argc(task) != 4 ){
    spl_report(SPL_REPORT_RUNTIME, task,"setLinVel: Parameter must be a int, float, float, float !\n" ) ;
    ((splPrg *)data)->TurnOff();
    return 0 ;
  } else {
   // hh,velx,vely,velz
   int hh= spl_clib_get_int(task);
   float velx= spl_clib_get_float(task);
   float vely= spl_clib_get_float(task);
   float velz= spl_clib_get_float(task);

   ((splPrg *)data)->ScriptApi->setLinVel ( hh,velx,vely,velz ) ;
   return 0 ;
  }
}

static struct spl_node *my_setRotation ( struct spl_task *task, void *data )
{
  if ( spl_clib_get_argc(task) != 4 ){
    spl_report(SPL_REPORT_RUNTIME, task,"setRotation: Parameter must be a int, float, float, float !\n" ) ;
    ((splPrg *)data)->TurnOff();
    return 0 ;
  } else {
   // hh,h,p,r
   int hh= spl_clib_get_int(task);
   float h= spl_clib_get_float(task);
   float p= spl_clib_get_float(task);
   float r= spl_clib_get_float(task);

   ((splPrg *)data)->ScriptApi->setRotation ( hh,h,p,r ) ;
   return 0 ;
  }
}

static struct spl_node *my_Rotation ( struct spl_task *task, void *data )
{
  if ( spl_clib_get_argc(task) != 4 ){
    spl_report(SPL_REPORT_RUNTIME, task,"setRotation: Parameter must be a int, float, float, float !\n" ) ;
    ((splPrg *)data)->TurnOff();
    return 0 ;
  } else {
   // hh,h,p,r
   int hh= spl_clib_get_int(task);
   float h= spl_clib_get_float(task);
   float p= spl_clib_get_float(task);
   float r= spl_clib_get_float(task);

   ((splPrg *)data)->ScriptApi->rotation ( hh,h,p,r ) ;
   return 0 ;
  }
}


static struct spl_node *my_setPosition ( struct spl_task *task, void *data )
{
  if ( spl_clib_get_argc(task) != 7 ){
    spl_report(SPL_REPORT_RUNTIME, task,"setPosition: Parameter must be a int, float, float, float, float, float, float !\n" ) ;
    ((splPrg *)data)->TurnOff();
    return 0 ;
  } else {
  // hh,x,y,z,h,p,r
   int hh= spl_clib_get_int(task);
   float x= spl_clib_get_float(task);
   float y= spl_clib_get_float(task);
   float z= spl_clib_get_float(task);
   float h= spl_clib_get_float(task);
   float p= spl_clib_get_float(task);
   float r= spl_clib_get_float(task);

   ((splPrg *)data)->ScriptApi->setPosition ( hh,x,y,z,h,p,r ) ;
   return 0 ;
  }
}

static struct spl_node *my_getRef ( struct spl_task *task, void *data )
{
  if ( spl_clib_get_argc(task) != 1 ){
    spl_report(SPL_REPORT_RUNTIME, task,"getRef: Parameter must ba a int !\n" ) ;
    ((splPrg *)data)->TurnOff();
    return 0 ;
  } else {
    return SPL_NEW_INT(((splPrg *)data)->ScriptApi->getRef ( spl_clib_get_int(task)));
  }
}

static struct spl_node *my_getJoystick ( struct spl_task *task, void *data )
{
  if ( spl_clib_get_argc(task) != 2 ){
    spl_report(SPL_REPORT_RUNTIME, task,"getJoystick: Parameter must be a int and a int !\n" ) ;
    ((splPrg *)data)->TurnOff();
    return 0 ;
  } else {
    int js=spl_clib_get_int(task);
    int ax=spl_clib_get_int(task);
    return SPL_NEW_FLOAT(((splPrg *)data)->ScriptApi->getJoystick ( js,ax ));
  }
}

static struct spl_node *my_getJoyButton ( struct spl_task *task, void *data )
{
  if ( spl_clib_get_argc(task) != 1 ){
    spl_report(SPL_REPORT_RUNTIME, task,"getJoyButton: Parameter must be a int !\n" ) ;
    ((splPrg *)data)->TurnOff();
    return 0 ;
  } else {
    return SPL_NEW_INT(((splPrg *)data)->ScriptApi->getJoyButton (spl_clib_get_int(task)));
  }
}

static struct spl_node *my_getMouse ( struct spl_task *task, void *data )
{
  if ( spl_clib_get_argc(task) != 1 ){
    spl_report(SPL_REPORT_RUNTIME, task,"getMouse: Parameter must be a int !\n" ) ;
    ((splPrg *)data)->TurnOff();
    return 0 ;
  } else {
    return SPL_NEW_INT(((splPrg *)data)->ScriptApi->getMouse ( spl_clib_get_int(task) ) ) ;
  }
}

static struct spl_node *my_getMouseButton ( struct spl_task *task, void *data )
{
  if ( spl_clib_get_argc(task) != 0 ){
    spl_report(SPL_REPORT_RUNTIME, task,"getMouseButton: no Parameter needs !\n" ) ;
    ((splPrg *)data)->TurnOff();
    return 0 ;
  } else {
    return SPL_NEW_INT(((splPrg *)data)->ScriptApi->getMouseButton () ) ;
  }
}

static struct spl_node *my_get3DMouse ( struct spl_task *task, void *data )
{
  if ( spl_clib_get_argc(task) != 1 ){
    spl_report(SPL_REPORT_RUNTIME, task,"get3DMouse: Parameter must be a int !\n" ) ;
    ((splPrg *)data)->TurnOff();
    return 0 ;
  } else {
    return SPL_NEW_FLOAT(((splPrg *)data)->ScriptApi->get3DMouse ( spl_clib_get_int(task) ) ) ;
  }
}

static struct spl_node *my_getAttribute ( struct spl_task *task, void *data )
{
  if ( spl_clib_get_argc(task) != 2 ){
    spl_report(SPL_REPORT_RUNTIME, task,"getAttribute: Parameter must be a int and a string !\n" ) ;
    ((splPrg *)data)->TurnOff();
    return 0 ;
  } else {
    int     hh=spl_clib_get_int(task);
    char *attr=spl_clib_get_string(task);
    return SPL_NEW_STRING_DUP(((splPrg *)data)->ScriptApi->getAttribute ( hh, attr ).toAscii().data() ) ;
  }
}

static struct spl_node *my_setAttribute ( struct spl_task *task, void *data )
{
  if ( spl_clib_get_argc(task) != 3 ){
    spl_report(SPL_REPORT_RUNTIME, task,"setAttribute: Parameter must be a int and a string and a string!\n" ) ;
    ((splPrg *)data)->TurnOff();
    return 0 ;
  } else {
    int   hh    =  spl_clib_get_int(task);
    char* attr  =  spl_clib_get_string(task);
    char* value =  spl_clib_get_string(task);
    return SPL_NEW_INT(((splPrg *)data)->ScriptApi->setAttribute ( hh , attr, value) ) ;
  }
}

static struct spl_node *my_getKey ( struct spl_task *task, void *data )
{
  if ( spl_clib_get_argc(task) != 0 ){
    spl_report(SPL_REPORT_RUNTIME, task,"my_getKey: no Parameter needs !\n" ) ;
    ((splPrg *)data)->TurnOff();
    return 0 ;
  } else {
    return SPL_NEW_INT(((splPrg *)data)->ScriptApi->getKey ( ) ) ;
  }
}

static struct spl_node *my_switchScene ( struct spl_task *task, void *data )
{
  if ( spl_clib_get_argc(task) != 1 ){
    spl_report(SPL_REPORT_RUNTIME, task,"switchScene: Parameter must be a single int!\n" ) ;
    ((splPrg *)data)->TurnOff();
    return 0 ;
  } else {
    ((splPrg *)data)->TurnOff();
    return SPL_NEW_INT(((splPrg *)data)->ScriptApi->switchScene (spl_clib_get_int(task) ) ) ;
  }
}

static struct spl_node *my_playSound ( struct spl_task *task, void *data )
{
  if ( spl_clib_get_argc(task) != 1 ){
    spl_report(SPL_REPORT_RUNTIME, task,"playSound: Parameter must be a single int!\n" ) ;
    ((splPrg *)data)->TurnOff();
    return 0;
  } else {
    ((splPrg *)data)->ScriptApi->playSound ( spl_clib_get_int(task) ) ;
    return 0;
  }
}

static struct spl_node *my_stopSound ( struct spl_task *task, void *data )
{
  if ( spl_clib_get_argc(task) != 1 ){
    spl_report(SPL_REPORT_RUNTIME, task,"stopSound: Parameter must be a single int!\n" ) ;
    ((splPrg *)data)->TurnOff();
    return 0;
  } else {
    ((splPrg *)data)->ScriptApi->stopSound ( spl_clib_get_int(task) ) ;
    return 0;
  }
}

static struct spl_node *my_switchCamera ( struct spl_task *task, void *data )
{
  if ( spl_clib_get_argc(task) != 1 ){
    spl_report(SPL_REPORT_RUNTIME, task,"switchCamera: Parameter must be a single int!\n" ) ;
    ((splPrg *)data)->TurnOff();
    return 0 ;
  } else
  return SPL_NEW_INT(((splPrg *)data)->ScriptApi->switchCamera (spl_clib_get_int(task) ) ) ;
}

static struct spl_node *my_srand ( struct spl_task *task, void *data )
{
  if ( spl_clib_get_argc(task) != 1 ){
    spl_report(SPL_REPORT_RUNTIME, task,"srand: Parameter must be a single int!\n" ) ;
    ((splPrg *)data)->TurnOff();
    return 0 ;
  } else
  return SPL_NEW_INT( ((splPrg *)data)->ScriptApi->srand (spl_clib_get_int(task) ) ) ;
}

static struct spl_node *my_astarFindPath ( struct spl_task *task, void *data )
{
  if ( spl_clib_get_argc(task) != 5 ){
    spl_report(SPL_REPORT_RUNTIME, task,"astarFindPath: Parameter must be a int, int, int, int, int !\n" ) ;
    ((splPrg *)data)->TurnOff();
    return 0 ;
  } else {
    int   pl    =  spl_clib_get_int(task);
    int   sx    =  spl_clib_get_int(task);
    int   sy    =  spl_clib_get_int(task);
    int   tx    =  spl_clib_get_int(task);
    int   ty    =  spl_clib_get_int(task);

    return SPL_NEW_INT(((splPrg *)data)->ScriptApi->astarFindPath ( pl,sx,sy,tx,ty) ) ;
  }
}

static struct spl_node *my_astarReadPathX ( struct spl_task *task, void *data )
{
  if ( spl_clib_get_argc(task) != 2 ){
    spl_report(SPL_REPORT_RUNTIME, task,"astarReadPathX: Parameter must be a int, int !\n" ) ;
    ((splPrg *)data)->TurnOff();
    return 0 ;
  } else {
    int   pl    =  spl_clib_get_int(task);
    int   sx    =  spl_clib_get_int(task);

    return SPL_NEW_INT(((splPrg *)data)->ScriptApi->astarReadPathX (pl,sx) ) ;
  }
}

static struct spl_node *my_astarReadPathY ( struct spl_task *task, void *data )
{
  if ( spl_clib_get_argc(task) != 2 ){
    spl_report(SPL_REPORT_RUNTIME, task,"astarReadPathY: Parameter must be a int, int !\n" ) ;
    ((splPrg *)data)->TurnOff();
    return 0 ;
  } else {
    int   pl    =  spl_clib_get_int(task);
    int   sy    =  spl_clib_get_int(task);

    return SPL_NEW_INT(((splPrg *)data)->ScriptApi->astarReadPathY (pl,sy) ) ;
  }
}

static struct spl_node *my_astarReadMap ( struct spl_task *task, void *data )
{
  if ( spl_clib_get_argc(task) != 1 ){
    spl_report(SPL_REPORT_RUNTIME, task,"astarReadPathY: Parameter must be a string !\n" ) ;
    ((splPrg *)data)->TurnOff();
    return 0 ;
  } else {
    char    *file    =  spl_clib_get_string(task);

    return SPL_NEW_INT(((splPrg *)data)->ScriptApi->astarReadMap (file) ) ;
  }
}

static struct spl_node *my_astarReadMapValue ( struct spl_task *task, void *data )
{
  if ( spl_clib_get_argc(task) != 2 ){
    spl_report(SPL_REPORT_RUNTIME, task,"astarReadPathY: Parameter must be a int int !\n" ) ;
    ((splPrg *)data)->TurnOff();
    return 0 ;
  } else {
    int    x    =  spl_clib_get_int(task);
    int    y    =  spl_clib_get_int(task);

    return SPL_NEW_INT(((splPrg *)data)->ScriptApi->astarReadMapValue (x,y) ) ;
  }
}

static struct spl_node *my_astarInit ( struct spl_task *task, void *data )
{
  if ( spl_clib_get_argc(task) != 4 ){
    spl_report(SPL_REPORT_RUNTIME, task,"astarReadPathY: Parameter must be a int int int int !\n" ) ;
    ((splPrg *)data)->TurnOff();
    return 0 ;
  } else {
    int width     =  spl_clib_get_int(task);
    int height    =  spl_clib_get_int(task);
    int size      =  spl_clib_get_int(task);
    int people    =  spl_clib_get_int(task);

    return SPL_NEW_INT(((splPrg *)data)->ScriptApi->astarInit (width, height, size, people) ) ;
  }
}

static struct spl_node *my_tmpobjInit ( struct spl_task *task, void *data )
{
  if ( spl_clib_get_argc(task) != 8 ){
    spl_report(SPL_REPORT_RUNTIME, task,"tmpobjInit: Parameter must be a int float float float float float float int!\n" ) ;
    ((splPrg *)data)->TurnOff();
    return 0 ;
  } else {
    int ref    =  spl_clib_get_int(task);
    float x    =  spl_clib_get_float(task);
    float y    =  spl_clib_get_float(task);
    float z    =  spl_clib_get_float(task);
    float h    =  spl_clib_get_float(task);
    float p    =  spl_clib_get_float(task);
    float r    =  spl_clib_get_float(task);
    int  id    =  spl_clib_get_int(task);
    return SPL_NEW_INT(((splPrg *)data)->ScriptApi->tmpobjInit (ref,x,y,z,h,p,r,id) ) ;
  }
}

//****************************************************************
 
 splPrg::splPrg(const char *prg):scriptPrg()
 {
     ScriptApi=QcakeScriptApi::theInstance();
     item = NULL;
     strcpy(prgname,prg);
     strcpy(prgsrc,prg);
     vm = spl_vm_create();
     spl_builtin_register_all(vm);

#ifdef    Q_OS_WIN32
     spl_set_report_func(spl_qt_reportfunc);  // only spl > 1.0-pre3 avaible
#endif
#ifndef    Q_OS_WIN32
     spl_report = spl_qt_reportfunc;
#endif

     QString  vmpath = QString(".:./spl_modules:%1").arg(spl_system_modules_dir());
     vm->path = strdup(vmpath.toAscii().data());
     task = spl_task_create(vm, 0);

     // register the language qcake routines
     spl_clib_reg(vm, (char *)"getPositionX" , my_getPositionX,  this);
     spl_clib_reg(vm, (char *)"getPositionY" , my_getPositionY,  this);
     spl_clib_reg(vm, (char *)"getPositionZ" , my_getPositionZ,  this);
     spl_clib_reg(vm, (char *)"getPositionH" , my_getPositionH,  this);
     spl_clib_reg(vm, (char *)"getPositionP" , my_getPositionP,  this);
     spl_clib_reg(vm, (char *)"getPositionR" , my_getPositionR,  this); 
     spl_clib_reg(vm, (char *)"getJoyButton" , my_getJoyButton,  this);
     spl_clib_reg(vm, (char *)"getJoystick"  , my_getJoystick ,  this);
     spl_clib_reg(vm, (char *)"addRelTorque" , my_addRelTorque,  this);
     spl_clib_reg(vm, (char *)"addRelForce"  , my_addRelForce ,  this);
     spl_clib_reg(vm, (char *)"setSequence"  , my_setSequence ,  this);
     spl_clib_reg(vm, (char *)"setAngVel"    , my_setAngularVel ,this);
     spl_clib_reg(vm, (char *)"setLinVel"    , my_setLinVel   ,  this);
     spl_clib_reg(vm, (char *)"setRotation"  , my_setRotation ,  this);
     spl_clib_reg(vm, (char *)"Rotate"       , my_Rotation    ,  this);
     spl_clib_reg(vm, (char *)"setPosition"  , my_setPosition ,  this);
     spl_clib_reg(vm, (char *)"getRef"       , my_getRef      ,  this);
     spl_clib_reg(vm, (char *)"getMouse"     , my_getMouse    ,  this);
     spl_clib_reg(vm, (char *)"get3DMouse"   , my_get3DMouse  ,  this);
     spl_clib_reg(vm, (char *)"getMouseButton"     , my_getMouseButton    ,  this);
     spl_clib_reg(vm, (char *)"getAttribute" , my_getAttribute,  this);
     spl_clib_reg(vm, (char *)"setAttribute" , my_setAttribute,  this);
     spl_clib_reg(vm, (char *)"getKey"       , my_getKey      ,  this);
     spl_clib_reg(vm, (char *)"switchScene"  , my_switchScene ,  this);
     spl_clib_reg(vm, (char *)"playSound"    , my_playSound   ,  this);
     spl_clib_reg(vm, (char *)"stopSound"    , my_stopSound   ,  this);
     spl_clib_reg(vm, (char *)"switchCamera" , my_switchCamera,  this);
     spl_clib_reg(vm, (char *)"srand"        , my_srand       ,  this);
     spl_clib_reg(vm, (char *)"astarFindPath" , my_astarFindPath    ,  this);
     spl_clib_reg(vm, (char *)"astarReadPathX" , my_astarReadPathX  ,  this);
     spl_clib_reg(vm, (char *)"astarReadPathY" , my_astarReadPathY  ,  this);
     spl_clib_reg(vm, (char *)"astarReadMap" , my_astarReadMap      ,  this);
     spl_clib_reg(vm, (char *)"astarReadMapValue" , my_astarReadMapValue  ,  this);
     spl_clib_reg(vm, (char *)"astarInit"    , my_astarInit   ,  this);
     spl_clib_reg(vm, (char *)"tmpobjInit"   , my_tmpobjInit  ,  this);
    
     // load the standard spl qcake library
     QString spl_stdlib_file = g_apppath + "/spl_stdlib.spl";
     char *spl_stdlib_code = (char *)spl_malloc_file(spl_stdlib_file.toAscii().data(), 0);
     assert(spl_stdlib_code != NULL);
     spl_eval(vm, 0, strdup("stdlib"), spl_stdlib_code);
     free(spl_stdlib_code);
 }

 int splPrg::compile(void)
 {
   spl_source = (char *)spl_malloc_file(prgsrc,0);
   as = spl_asm_create();
   if(spl_compiler(as,spl_source,prgsrc,qcakespl_malloc_file,1)){
      spl_asm_add(as,SPL_OP_HALT,0);
      return 1;
   } else {
      spl_asm_add(as,SPL_OP_HALT,0);
      free(spl_source);
//      spl_optimizer(as);
      spl_task_setcode(task, spl_asm_dump(as));
      spl_asm_destroy(as);
      spl_eval(vm, 0, 0,"function freeze() { asm 'pushc 200' 'rlret'; }");
      return 0;
   }
 }

 void splPrg::update(void)
 {
  while ( task && task->code && on==1 && g_playmode==1)
  {
   spl_gc_maybe(vm);
   task = spl_schedule(task); 
   if(spl_exec(task)) break;
  }
 }

 splPrg::~splPrg()
 {
    spl_vm_destroy(vm);
 }
