//
// C++ Implementation: CShaderEdit
//
// Description: 
//
//
// Author: Harald Krippel <harald@the-develop.net>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include <QtGui>

#include "CQcakeDlg.hpp"
#include "CShaderEdit.hpp"
#include "main.h"

CShaderEditDlg::CShaderEditDlg(QString strTitle, QWidget * parent, Qt::WFlags f)
: CQcakeDlg(parent, f)
{
   point = NULL;
   ui.setupUi(this);
    
   connect(ui.buttonBox, SIGNAL(accepted()), this, SLOT(slotEditData()));
   connect(ui.buttonBox, SIGNAL(rejected()), this, SLOT(slotGetData()));
   connect(ui.pushButton3, SIGNAL(released()), this, SLOT(slotEditorScriptv()));
   connect(ui.pushButton4, SIGNAL(released()), this, SLOT(slotEditorScriptf()));
   connect(ui.toolButton1, SIGNAL(released()), this, SLOT(slotGetScriptv()));
   connect(ui.toolButton1, SIGNAL(released()), this, SLOT(slotGetScriptf()));

   myParent = parent;
   setWindowTitle(strTitle);
}

CShaderEditDlg::~CShaderEditDlg() {
}

void CShaderEditDlg::slotGetData()
{
    if(point != NULL){
      slotGetData(point);
    }
}

void CShaderEditDlg::slotGetData(FolderListItem *i)
{
    point=i;
	
    ui.text->setText(i->text(0));
    ui.on->setChecked(i->GetValue("on",i).toInt());

    ui.vfile->setText(i->GetValue("vfile",i));
    ui.ffile->setText(i->GetValue("ffile",i));

    qWarning( "CShaderEditDlg::slotGetData(): Geht !" );
}

void CShaderEditDlg::slotEditData()
{
    if(point != NULL)
    {
        point->setText(0,ui.text->text());
        point->SetValue("on", ui.on->isChecked() ? "1" : "0");

//  implement later
//    point->SetValue("vfile",ui.vfile->text());
//    point->SetValue("ffile",ui.ffile->text());

        point->updategl();
    }
    qWarning( "CShaderEditDlg::slotEditData(): Geht !" );
}

void CShaderEditDlg::slotEditorScriptv()
{
    QString   arg = g_prjpath + point->GetValue("path",point ) + "/" + point->GetValue("vfile",point) ;
    slotEditorScript(arg);
    qWarning( "MySplEditDlg::EditorScriptv(): Geht !" );
}

void CShaderEditDlg::slotEditorScriptf()
{
    QString   arg = g_prjpath + point->GetValue("path",point ) + "/" + point->GetValue("ffile",point) ;
    slotEditorScript(arg);
    qWarning( "MySplEditDlg::EditorScriptf(): Geht !" );
}

void CShaderEditDlg::slotEditorScript(QString arg)
{
    QProcess*  proc = new QProcess( this );
    QStringList arguments;
    arguments << arg;
    qWarning( arg.toAscii() );   // error handling
#ifdef    Q_OS_IRIX
    QString program = "jot";
    proc->start(program, arguments);
    if ( !proc->waitForStarted()) {
      qWarning( "MySplEditDlg::EditorScript(): cant start jot" );   // error handling
    }
#endif
#ifdef    Q_OS_LINUX
    QString program = "kwrite";
    proc->start(program, arguments);
    if ( !proc->waitForStarted()) {
      qWarning( "MySplEditDlg::EditorScript(): cant start kwrite" );   // error handling
    }
#endif
#ifdef    Q_OS_MACX
    QString program = "/Applications/TextEdit.app/Contents/MacOS/TextEdit";
    proc->start(program, arguments);
    if ( !proc->waitForStarted()) {
      qWarning( "MySplEditDlg::EditorScript(): cant start TextEdit" );   // error handling
    }
#endif
#ifdef    Q_OS_WIN32
//    QString program = "C:\Programme\Windows NT\Zubeh�r\wordpade.exe";
    QString program = "notepad";
    proc->start(program, arguments);
    if ( !proc->waitForStarted()) {
      qWarning( "MySplEditDlg::EditorScript(): cant start edit" );   // error handling
    }
#endif
    qWarning( "MySplEditDlg::EditorScript(): Geht !" );
}

void CShaderEditDlg::slotGetScriptv()
{
    qWarning( "MySplEditDlg::slotGetScriptv(): Geht !" );
}

void CShaderEditDlg::slotGetScriptf()
{
    qWarning( "MySplEditDlg::slotGetScriptf(): Geht !" );
}

