/***************************************************************************
 $RCSfile$
                             -------------------
    cvs         : $Id$
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/

#ifndef AQBANKING_KDE_CALCPAYEE_H
#define AQBANKING_KDE_CALCPAYEE_H


class KBanking;
class Transaction;
class QWidget;
class Payee;


#include "checkduplicates.ui.h"
#include <aqbanking/value.h>
#include "refpointer.h"
#include "transaction.h"

#include <list>
#include <string>

class CalculatePayee : public CheckDuplicatesUI {
  Q_OBJECT
private:
  KBanking *_app;
  bool _aborted;
  Payee *_payee;
  AB_VALUE *_inVal;
  AB_VALUE *_outVal;

public:
  CalculatePayee(KBanking *kb,
                 Payee *p=0,
                 AB_VALUE *inVal=0,
                 AB_VALUE *outVal=0,
                 QWidget* parent=0,
                 const char* name=0,
                 WFlags fl=0);
  ~CalculatePayee();

  bool calculate();
  bool calculateAll();

  bool getTransactions(std::list<RefPointer<Transaction> > &l);

public slots:
  void slotAbortClicked();

};







#endif


