//
// C++ Implementation:
//
// Description:
//
//
// Author: Sebastian Holtermann <sebholt@xwmw.org>, (C) 2011
//
// Copyright: See COPYING file that comes with this distribution
//
//

#include "switches_pad_proxies_group.hpp"

#include <wdg/event_types.hpp>
#include <wdg/pass_events.hpp>

#include <QCoreApplication>


namespace Wdg
{


Switches_Pad_Proxies_Group::Switches_Pad_Proxies_Group (
	QObject * parent_n ) :
QObject ( parent_n ),
_switches_pad ( 0 ),
_group_index ( 0 ),
_focus_proxy ( 0 ),
_is_switch ( false ),
_is_enum ( false ),
_has_focus ( false )
{
}


Switches_Pad_Proxies_Group::~Switches_Pad_Proxies_Group ( )
{
	clear_proxies();
}


void
Switches_Pad_Proxies_Group::set_switches_pad (
	QObject * pad_n )
{
	_switches_pad = pad_n;
}


void
Switches_Pad_Proxies_Group::set_group_index (
	unsigned int idx_n )
{
	_group_index = idx_n;
}


void
Switches_Pad_Proxies_Group::clear_proxies ( )
{
	if ( _proxies.size() > 0 ) {
		for ( int ii=0; ii < _proxies.size(); ++ii ) {
			delete _proxies[ii];
		}
		_proxies.clear();
	}
}


void
Switches_Pad_Proxies_Group::append_proxy (
	Switches_Pad_Proxy * proxy_n )
{
	if ( proxy_n != 0 ) {
		proxy_n->setParent ( this );
		proxy_n->set_index ( _proxies.size() );
		_proxies.append ( proxy_n );
	}
}


void
Switches_Pad_Proxies_Group::set_is_switch (
	bool flag_n )
{
	_is_switch = flag_n;
}


void
Switches_Pad_Proxies_Group::set_is_enum (
	bool flag_n )
{
	_is_enum = flag_n;
}


bool
Switches_Pad_Proxies_Group::event (
	QEvent * event_n )
{
	if ( event_n->type() == ::Wdg::evt_pass_event_focus ) {
		::Wdg::Pass_Event_Focus * ev_fp (
			static_cast < ::Wdg::Pass_Event_Focus * > ( event_n ) );

		_has_focus = ev_fp->ev_focus.gotFocus();
		_focus_proxy = ev_fp->column_idx;

		if ( switches_pad() != 0 ) {
			ev_fp->group_idx = group_index();
			QCoreApplication::sendEvent ( switches_pad(), event_n );
		}
		return true;
	}

	return QObject::event ( event_n );
}


} // End of namespace
