//
// C++ Interface:
//
// Description:
//
//
// Author: Sebastian Holtermann <sebholt@xwmw.org>, (C) 2011
//
// Copyright: See COPYING file that comes with this distribution
//
//

#ifndef __INC_mixer_ctl_proxies_group_hpp__
#define __INC_mixer_ctl_proxies_group_hpp__

#include <QObject>
#include "mixer_ctl_proxy.hpp"


namespace MWdg
{


///
/// @brief Mixer_CTL_Proxies_Group
///
class Mixer_CTL_Proxies_Group :
	public QObject
{
	Q_OBJECT

	// Public methods
	public:

	Mixer_CTL_Proxies_Group (
		QObject * parent_n );

	~Mixer_CTL_Proxies_Group ( );


	unsigned int
	num_proxies ( ) const;

	Mixer_CTL_Proxy *
	proxy (
		unsigned int idx_n ) const;

	void
	append_proxy (
		Mixer_CTL_Proxy * proxy_n );


	// Public slots
	public slots:

	void
	update_values ( );

	void
	set_joined (
		bool flag_n );


	// Private attributes
	private:

	QList < Mixer_CTL_Proxy * > _proxies;
};


inline
unsigned int
Mixer_CTL_Proxies_Group::num_proxies ( ) const
{
	return _proxies.size();
}


inline
Mixer_CTL_Proxy *
Mixer_CTL_Proxies_Group::proxy (
	unsigned int idx_n ) const
{
	return _proxies[idx_n];
}


inline
void
Mixer_CTL_Proxies_Group::append_proxy (
	Mixer_CTL_Proxy * proxy_n )
{
	if ( proxy_n != 0 ) {
		_proxies.append ( proxy_n );
		proxy_n->setParent ( this );
	}
}


} // End of namespace


#endif
