//
// C++ Interface:
//
// Description:
//
//
// Author: Sebastian Holtermann <sebholt@xwmw.org>, (C) 2011
//
// Copyright: See COPYING file that comes with this distribution
//
//

#ifndef __INC_mixer_ctl_int_proxy_column_hpp__
#define __INC_mixer_ctl_int_proxy_column_hpp__

#include <QObject>
#include <QLocale>
#include <wdg/sliders_pad_proxies_column.hpp>
#include "mixer_ctl_int_proxy_slider.hpp"


namespace MWdg
{


///
/// @brief Mixer_CTL_Int_Proxy_Column
///
class Mixer_CTL_Int_Proxy_Column :
	public ::Wdg::Sliders_Pad_Proxies_Column
{
	Q_OBJECT

	// Public methods
	public:

	Mixer_CTL_Int_Proxy_Column ( );

	~Mixer_CTL_Int_Proxy_Column ( );


	Mixer_CTL_Int_Proxy_Slider *
	mslider_proxy ( ) const;


	// Value string

	QString
	value_string ( ) const;

	QString
	value_min_string ( ) const;

	QString
	value_max_string ( ) const;


	// Protected methods
	protected:

	void
	slider_proxy_changed ( );

	void
	show_value_string_changed ( );

	void
	update_connections ( );

	void
	integer_string (
		QString & str_n,
		long value_n ) const;

	void
	dB_string (
		QString & str_n,
		long dB_value_n ) const;

	void
	percent_string (
		QString & str_n,
		int permille_n ) const;


	// Private attributes
	private:

	QString _str_value_dB;
	QString _str_value_pc;
	QLocale _loc;
};


inline
Mixer_CTL_Int_Proxy_Slider *
Mixer_CTL_Int_Proxy_Column::mslider_proxy ( ) const
{
	return static_cast < Mixer_CTL_Int_Proxy_Slider * > (
		slider_proxy() );
}


} // End of namespace


#endif
