//
// C++ Interface:
//
// Description:
//
//
// Author: Sebastian Holtermann <sebholt@xwmw.org>, (C) 2011
//
// Copyright: See COPYING file that comes with this distribution
//
//

#ifndef __INC_mixer_ctl_editor_int_hpp__
#define __INC_mixer_ctl_editor_int_hpp__

#include <mwdg/mixer_ctl_editor.hpp>
#include <wdg/scroll_area_horizontal.hpp>
#include <wdg/sliders_pad_proxies_group.hpp>
#include <wdg/sliders_pad.hpp>
#include <QList>
#include <QPointer>
#include <QMenu>
#include <QAction>


namespace MWdg
{

// Forward declaration
class Mixer_CTL_Int_Proxy_Slider;
class Mixer_CTL_Int_Proxies_Group;
class Mixer_CTL_Slider_Status_Widget;


/// @brief Mixer_CTL_Edit_Int
///
class Mixer_CTL_Edit_Int :
	public Mixer_CTL_Editor
{
	Q_OBJECT

	// Public methods
	public:

	Mixer_CTL_Edit_Int (
		Mixer_CTL_Editor_Data * data_n,
		QWidget * parent_n = 0 );

	~Mixer_CTL_Edit_Int ( );

	void
	clear ( );

	void
	rebuild ( );


	void
	set_inputs_setup (
		const ::MWdg::Inputs_Setup * setup_n );


	void
	update_proxies_values ( );


	QString
	integer_string (
		long value_n ) const;

	QString
	dB_string (
		double value_n ) const;


	bool
	event (
		QEvent * event_n );

	bool
	eventFilter (
		QObject * watched_n,
		QEvent * event_n );


	// Protected slots
	protected slots:

	void
	update_focus_proxies ( );

	void
	context_menu_cleanup_behind ( );

	void
	action_toggle_joined ( );

	void
	action_level_volumes ( );

	void
	footer_label_selected (
		unsigned int group_idx_n,
		unsigned int column_idx_n );


	// Private methods
	private:

	void
	setup_single ( );

	void
	setup_multi ( );

	void
	setup_widgets ( );

	QLayout *
	create_range_label ( );

	::Wdg::Sliders_Pad_Proxies_Group *
	create_proxies_group (
		::QSnd::Mixer_CTL_Elem * elem_n,
		bool multi_n = false );

	// Context menu

	bool
	context_menu_start (
		const QPoint & pos_n );

	/// @return The number of visible actions
	unsigned int
	context_menu_update ( );


	// Private attributes
	private:

	QList < ::MWdg::Mixer_CTL_Int_Proxy_Slider * > _proxies_slider;
	QList < ::Wdg::Sliders_Pad_Proxies_Group * > _proxies_groups;

	::Wdg::Scroll_Area_Horizontal * _scroll_area;
	::Wdg::Sliders_Pad * _sliders_pad;

	// Slider status widget
	QPointer < ::MWdg::Mixer_CTL_Slider_Status_Widget > _status_wdg;
	unsigned int _status_group_idx;
	unsigned int _status_column_idx;

	// Context menu
	QPointer < ::MWdg::Mixer_CTL_Int_Proxies_Group > _focus_proxies_group;
	unsigned int _focus_proxy_column;

	QPointer < ::MWdg::Mixer_CTL_Int_Proxies_Group > _act_proxies_group;
	unsigned int _act_proxy_column;

	QMenu _cmenu;
	QAction _act_toggle_joined;
	QAction _act_level_channels;

	QString _range_mask;
	QString _range_ttip;
	QString _str_int_range;
	QString _str_dB_range;
};


} // End of namespace


#endif
