//
// C++ Interface:
//
// Description:
//
//
// Author: Sebastian Holtermann <sebholt@xwmw.org>, (C) 2011
//
// Copyright: See COPYING file that comes with this distribution
//
//

#ifndef __INC_controls_view_hpp__
#define __INC_controls_view_hpp__

#include <QTreeView>


// Forward declaration
namespace MWdg {
	class Controls_View_Setup;
}


namespace MWdg
{


/// @brief Controls_View
///
class Controls_View :
	public QTreeView
{
	Q_OBJECT

	// Public methods
	public:

	Controls_View (
		QWidget * parent = 0 );

	~Controls_View ( );


	QSize
	minimumSizeHint ( ) const;

	QSize
	sizeHint ( ) const;

	int
	sizeHintForColumn (
		int column ) const;


	void
	set_view_setup (
		::MWdg::Controls_View_Setup * setup_n );

	void
	setModel (
		QAbstractItemModel * model_n );


	bool
	event (
		QEvent * event_n );


	// Protected slots
	protected slots:

	void
	item_expanded ( );

	void
	maximum_height_update_request ( );

	void
	save_state ( );

	void
	restore_state ( );


	// Protected methods
	protected:

	void
	currentChanged (
		const QModelIndex & current,
		const QModelIndex & previous );

	void
	maximum_height_update ( );

	unsigned int
	height_sum_recursive (
		const QModelIndex & idx_n );


	// Private attributes
	private:

	::MWdg::Controls_View_Setup * _view_setup;

	int _show_rows_min;
	int _show_rows_avrg;
	int _min_chars_vis;

	bool _maximum_update_requested;
	bool _restoring_state;
};


} // End of namespace


#endif
