//
// C++ Interface:
//
// Description:
//
//
// Author: Sebastian Holtermann <sebholt@xwmw.org>, (C) 2011
//
// Copyright: See COPYING file that comes with this distribution
//
//

#ifndef __INC_mv_base_hpp__
#define __INC_mv_base_hpp__

#include <QWidget>
#include <QStackedLayout>


// Forward declaration
namespace MWdg {
	class Mixer_Device_Setup;
	class Inputs_Setup;
}
namespace MView {
	class Message_Widget;
	class MV_Base_Setup;
}


namespace MView
{


class MV_Base :
	public QWidget
{
	Q_OBJECT

	// Public methods
	public:

	MV_Base (
		QWidget * parent_n = 0 );

	virtual
	~MV_Base ( );


	/// The stacked layout holds the actual view widget and a
	/// (most times) hidden message widget that can be used for
	/// displaying error or info texts.
	QStackedLayout *
	lay_stack ( ) const;

	/// @brief The message widget is mostly used for error messages
	///
	Message_Widget *
	message_wdg ( );


	// Mixer device setup

	/// @brief Mixer device setup
	///
	/// @return The setup
	const ::MWdg::Mixer_Device_Setup *
	mdev_setup ( );

	virtual
	void
	set_mdev_setup (
		const ::MWdg::Mixer_Device_Setup * setup_n );


	// Input setup (keyboard/mouse)

	/// @brief Inputs (keyboard/mouse) setup
	///
	/// @return The setup
	const ::MWdg::Inputs_Setup *
	inputs_setup ( );

	virtual
	void
	set_inputs_setup (
		const ::MWdg::Inputs_Setup * setup_n );


	// View setup (colors, element selection, etc.)

	virtual
	void
	set_view_setup (
		::MView::MV_Base_Setup * setup_n ) = 0;


	// Signals
	signals:

	void
	sig_mdev_reload_request ( );


	// Private attributes
	private:

	const ::MWdg::Mixer_Device_Setup * _mdev_setup;
	const ::MWdg::Inputs_Setup * _inputs_setup;
	::MView::Message_Widget * _message_wdg;
};


inline
const ::MWdg::Mixer_Device_Setup *
MV_Base::mdev_setup ( )
{
	return _mdev_setup;
}


inline
const ::MWdg::Inputs_Setup *
MV_Base::inputs_setup ( )
{
	return _inputs_setup;
}


inline
QStackedLayout *
MV_Base::lay_stack ( ) const
{
	return dynamic_cast < QStackedLayout * > ( layout() );
}


inline
Message_Widget *
MV_Base::message_wdg ( )
{
	return _message_wdg;
}


} // End of namespace

#endif
