//
// C++ Interface:
//
// Description:
//
//
// Author: Sebastian Holtermann <sebholt@xwmw.org>, (C) 2011
//
// Copyright: See COPYING file that comes with this distribution
//
//

#ifndef __INC_mv_dev_select_view_hpp__
#define __INC_mv_dev_select_view_hpp__

#include <qsnd/control_address.hpp>
#include <QWidget>


// Forward declaration
class QModelIndex;
namespace MWdg {
	class Controls_Model;
	class Controls_View;
}
namespace MView {
	class Dev_Select_View_Setup;
}


namespace MView
{


/// @brief Dev_Select_View
///
class Dev_Select_View :
	public QWidget
{
	Q_OBJECT

	// Public methods
	public:

	Dev_Select_View (
		QWidget * parent_n = 0 );

	~Dev_Select_View ( );


	void
	set_view_setup (
		::MView::Dev_Select_View_Setup * setup_n );


	const ::QSnd::Control_Address &
	default_ctl ( ) const;

	const ::QSnd::Control_Address &
	selected_ctl ( ) const;

	void
	update_selected_ctl (
		const ::QSnd::Control_Address & ctl_n );


	// Signals
	signals:

	void
	sig_close ( );

	void
	sig_control_changed ( );


	// Public slots
	public slots:

	void
	reload_devices_list ( );


	// Protected slots
	protected slots:

	void
	control_selected (
		const QModelIndex & idx_n );

	void
	restore_selected_ctl ( );


	// Protected methods
	protected:

	void
	contextMenuEvent (
		QContextMenuEvent * event_n );


	// Private attributes
	private:

	::MView::Dev_Select_View_Setup * _view_setup;

	::QSnd::Control_Address _selected_ctl;
	::MWdg::Controls_Model * _controls_model;
	::MWdg::Controls_View * _controls_view;

	// Context menu
	QAction * _act_close;
};


inline
const ::QSnd::Control_Address &
Dev_Select_View::selected_ctl ( ) const
{
	return _selected_ctl;
}


} // End of namespace


#endif
