//
// C++ Implementation:
//
// Description:
//
//
// Author: Sebastian Holtermann <sebholt@xwmw.org>, (C) 2011
//
// Copyright: See COPYING file that comes with this distribution
//
//

#include "desktop_items_setup.hpp"

#include <QSettings>
#include <iostream>


Desktop_Items_Setup::Desktop_Items_Setup ( ) :
tray_on_close ( true ),
tray_show_icon ( true ),
tray_is_minimized ( false )
{
}


void
Desktop_Items_Setup::read_from_storage ( )
{
	QSettings settings;

	mixer_window.window_state = settings.value (
		"main_window_state",
		mixer_window.window_state ).toByteArray();

	mixer_window.window_geometry = settings.value (
		"main_window_geometry",
		mixer_window.window_geometry ).toByteArray();

	mixer_window.switcher.view_type = settings.value (
		"view_type",
		mixer_window.switcher.view_type ).toUInt();

	mixer_window.show_dev_select = settings.value (
		"show_device_selection",
		mixer_window.show_dev_select ).toBool();

	mixer_window.switcher.show_vtype_select = settings.value (
		"show_vtype_selection",
		mixer_window.switcher.show_vtype_select ).toBool();

	mixer_window.switcher.inputs.wheel_degrees = settings.value (
		"wheel_degrees",
		mixer_window.switcher.inputs.wheel_degrees ).toUInt();


	tray_on_close = settings.value (
		"tray_on_close",
		tray_on_close ).toBool();

	tray_show_icon = settings.value (
		"tray_show_icon",
		tray_show_icon ).toBool();

	tray_is_minimized = settings.value (
		"tray_is_minimized",
		tray_is_minimized ).toBool();


	// Device selection
	{
		::MWdg::Controls_View_Setup & vsetup (
			mixer_window.dev_select.ctl_view );

		settings.beginGroup ( "device_selection" );

		vsetup.expanded_items = settings.value (
			"expanded_items",
			vsetup.expanded_items ).toStringList();

		settings.endGroup();
	}


	// Simple mixer
	{
		::MView::MV_Mixer_Simple_Setup & vsetup (
			mixer_window.switcher.mv_simple );

		settings.beginGroup ( "simple_mixer" );

		vsetup.show_stream[0] = settings.value (
			"show_stream_playback",
			vsetup.show_stream[0] ).toBool();

		vsetup.show_stream[1] = settings.value (
			"show_stream_capture",
			vsetup.show_stream[1] ).toBool();

		vsetup.show_slider_value_labels = settings.value (
			"show_slider_value_labels",
			vsetup.show_slider_value_labels ).toBool();

		settings.endGroup();
	}



	// CTL mixer
	{
		::MView::MV_Mixer_CTL_Setup & vsetup (
			mixer_window.switcher.mv_ctl );

		settings.beginGroup ( "element_mixer" );

		vsetup.iface_name = settings.value (
			"iface_name",
			vsetup.iface_name ).toString();

		vsetup.elem_grp_name = settings.value (
			"elem_grp_name",
			vsetup.elem_grp_name ).toString();

		vsetup.elem_grp_index = settings.value (
			"elem_grp_index",
			vsetup.elem_grp_index ).toUInt();

		settings.endGroup();
	}


	// Alsa config view
	{
		::MView::Alsa_Config_View_Setup & vsetup (
			alsa_cfg_view );

		settings.beginGroup ( "alsa_config_view" );

		vsetup.sorted = settings.value (
			"sorted",
			vsetup.sorted ).toBool();

		settings.endGroup();
	}


	// Tray mixer
	{
		settings.beginGroup ( "tray_mixer" );

		Tray_Mixer_MDev_Setup & dsetup (
			tray_mdev );

		dsetup.device_mode = settings.value (
			"device_mode",
			dsetup.device_mode ).toInt();

		dsetup.user_device = settings.value (
			"user_device",
			dsetup.user_device ).toString();


		Tray_Mixer_View_Setup & vsetup (
			tray_view );

		vsetup.show_balloon = settings.value (
			"show_balloon",
			vsetup.show_balloon ).toBool();

		vsetup.balloon_lifetime = settings.value (
			"balloon_lifetime",
			vsetup.balloon_lifetime ).toUInt();

		settings.endGroup();
	}


	// Settings view
	{
		settings.beginGroup ( "settings_view" );

		settings_view.page = settings.value (
			"page",
			settings_view.page ).toUInt();

		settings.endGroup();
	}


	// Sanitize values

	if ( mixer_window.switcher.view_type > 2 ) {
		mixer_window.switcher.view_type = 0;
	}

	if ( mixer_window.switcher.inputs.wheel_degrees == 0 ) {
		mixer_window.switcher.inputs.wheel_degrees = 720;
	}
	tray_view.wheel_degrees = mixer_window.switcher.inputs.wheel_degrees;

	if ( tray_mdev.device_mode > ::Tray_Mixer_MDev_Setup::MIXER_DEV_LAST ) {
		tray_mdev.device_mode = ::Tray_Mixer_MDev_Setup::MIXER_DEV_DEFAULT;
	}

	{
		::MView::MV_Mixer_Simple_Setup & vsetup (
			mixer_window.switcher.mv_simple );

		if ( !( vsetup.show_stream[0] || vsetup.show_stream[1] ) ) {
			vsetup.show_stream[0] = true;
		}
	}
}


void
Desktop_Items_Setup::write_to_storage ( )
{
	//::std::cout << "Desktop_Items_Setup::write_to_storage" << "\n";

	QSettings settings;

	// General

	settings.setValue (
		"view_type",
		mixer_window.switcher.view_type );

	settings.setValue (
		"show_device_selection",
		mixer_window.show_dev_select );

	settings.setValue (
		"show_vtype_selection",
		mixer_window.switcher.show_vtype_select );

	settings.setValue (
		"wheel_degrees",
		mixer_window.switcher.inputs.wheel_degrees );


	settings.setValue (
		"tray_on_close",
		tray_on_close );

	settings.setValue (
		"tray_show_icon",
		tray_show_icon );

	settings.setValue (
		"tray_is_minimized",
		tray_is_minimized );


	settings.setValue (
		"main_window_state",
		mixer_window.window_state );

	settings.setValue (
		"main_window_geometry",
		mixer_window.window_geometry );


	// Device selection
	{
		const ::MWdg::Controls_View_Setup & vsetup (
			mixer_window.dev_select.ctl_view );

		settings.beginGroup ( "device_selection" );

		settings.setValue (
			"expanded_items",
			vsetup.expanded_items );

		settings.endGroup();
	}


	// Simple mixer
	{
		const ::MView::MV_Mixer_Simple_Setup & vsetup (
			mixer_window.switcher.mv_simple );

		settings.beginGroup ( "simple_mixer" );

		settings.setValue (
			"show_stream_playback",
			vsetup.show_stream[0] );

		settings.setValue (
			"show_stream_capture",
			vsetup.show_stream[1] );

		settings.setValue (
			"show_slider_value_labels",
			vsetup.show_slider_value_labels );

		settings.endGroup();
	}



	// CTL mixer view
	{
		const ::MView::MV_Mixer_CTL_Setup & vsetup (
			mixer_window.switcher.mv_ctl );

		settings.beginGroup ( "element_mixer" );

		settings.setValue (
			"iface_name",
			vsetup.iface_name );

		settings.setValue (
			"elem_grp_name",
			vsetup.elem_grp_name );

		settings.setValue (
			"elem_grp_index",
			vsetup.elem_grp_index );

		settings.endGroup();
	}


	// Alsa config view
	{
		const ::MView::Alsa_Config_View_Setup & vsetup (
			alsa_cfg_view );

		settings.beginGroup ( "alsa_config_view" );

		settings.setValue (
			"sorted",
			vsetup.sorted );

		settings.endGroup();
	}


	// Mini mixer
	{

		settings.beginGroup ( "tray_mixer" );

		const Tray_Mixer_MDev_Setup & dsetup (
			tray_mdev );

		settings.setValue (
			"device_mode",
			dsetup.device_mode );

		settings.setValue (
			"user_device",
			dsetup.user_device );


		const Tray_Mixer_View_Setup & vsetup (
			tray_view );

		settings.setValue (
			"show_balloon",
			vsetup.show_balloon );

		settings.setValue (
			"balloon_lifetime",
			vsetup.balloon_lifetime );

		settings.endGroup();
	}


	// Settings view
	{
		settings.beginGroup ( "settings_view" );

		settings.setValue (
			"page",
			settings_view.page );

		settings.endGroup();
	}
}
