/***************************************************************************
                      job_modifyplaylists.cpp  -  description
                             -------------------
    begin                : Wed May 9 2001
    copyright            : (C) 2001 by Holger Sattel
    email                : hsattel@rumms.uni-mannheim.de
 
    Contributed by Tim Lee ;-)
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "job_modifyplaylists.h"

#include "job_disconnectfromdatabase.h"

#include "jobmanager.h"
#include "database.h"
#include "datadispatcher.h"

#ifdef EMBEDDED
#include <mysql.h>
#endif

// appending
Job_ModifyPlaylists::Job_ModifyPlaylists(int _mode, QString _listname)
: mode(_mode), listname(_listname) {}

// deleting
Job_ModifyPlaylists::Job_ModifyPlaylists(int _mode, LVI_Playlist *_playlist)
: mode(_mode), playlist(_playlist) {}

// renaming
Job_ModifyPlaylists::Job_ModifyPlaylists(int _mode, LVI_Playlist *_playlist, QString _newname)
: mode(_mode), playlist(_playlist), newname(_newname) {}

void Job_ModifyPlaylists::run() {
    int error;
    int ID;

    if (verbose==8)
        qWarning( "    >run() tread:%p type:%s HANDLE:%p", this, JOB_CODE[type()], currentThread() );

    #ifdef EMBEDDED

    mysql_thread_init();
    #endif

    database->lock()
    ;
    if(mode == APPEND_PLAYLIST)
        ID = database->appendPlaylist(listname);
    else if(mode == RENAME_PLAYLIST)
        database->renamePlaylist(playlist->getID(),newname);
    else if(mode == DELETE_PLAYLIST)
        database->deletePlaylist(playlist->getID());

    error = database->getError();
    database->unlock();

    if(!error) {
        database->lock()
        ;
        app->lock()
        ;
        if(mode == APPEND_PLAYLIST) {
            PLAYLIST *temp_pl;
            temp_pl = new PLAYLIST();
            temp_pl->id = ID;
            temp_pl->name = listname;
            datadispatcher->eventNewPlaylist(temp_pl, true);
        } else if(mode == RENAME_PLAYLIST)
            datadispatcher->eventRenamePlaylist(playlist, newname);
        else if(mode == DELETE_PLAYLIST) {
            datadispatcher->eventRemovePlaylist(playlist);
        }
        app->unlock();
        database->unlock();
    }

    jobman->lock()
    ;
    jobman->jobDone(this);
    jobman->unlock();
    #ifdef EMBEDDED

    mysql_thread_end();
    #endif

    if (verbose==8)
        qWarning( "    >exit() thread:%p type:%s HANDLE: %p", this, JOB_CODE[type()], currentThread() );

    exit();
}

Job_ModifyPlaylists::~Job_ModifyPlaylists() {}
