/***************************************************************************
                    job_modifyplaylist_tracks.h  -  description
                             -------------------
    begin                : Wed May 9 2001
    copyright            : (C) 2001 by Holger Sattel
    email                : hsattel@rumms.uni-mannheim.de
 
    Contributed by Tim Lee ;-)
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef JOB_MODIFYPLAYLIST_TRACKS_H
#define JOB_MODIFYPLAYLIST_TRACKS_H

#include "prokyon.h"

#include "jobbase.h"

#include "lvi_playlisttrack.h"

#define APPEND_PLAYLIST_TRACK   1
#define UPDATE_PLAYLIST_TRACK   2
#define DELETE_PLAYLIST_TRACK   3
#define APPEND_TO_CURRENT       4
#define SAVE_POSITIONS           5

class Job_ModifyPlaylist_Tracks : public JobBase  {
public:
    Job_ModifyPlaylist_Tracks(int _mode, QList<TRACK> *_list, int _playlistID);
    Job_ModifyPlaylist_Tracks(int _mode, LVI_PlaylistTrack *_lvi_pl_track, int _position = -1);
    Job_ModifyPlaylist_Tracks(int _mode, QList<LVI_PlaylistTrack> *_pl_track_list);
    Job_ModifyPlaylist_Tracks(int _mode, int _playlistID, QList<int> *_positionlist);

    int type() {
        return JOB_MODIFY_PLAYLIST_TRACKS;
    }

    void run();

    ~Job_ModifyPlaylist_Tracks();

private:
    int mode;
    QList<int> *positionlist;
    QList<TRACK> *list;
    QList<LVI_PlaylistTrack> *pl_track_list;
    int playlistID;
    int position;
    LVI_PlaylistTrack *lvi_pl_track;
};

#endif
