//
//  PRImage.m
//  PRICE
//
//  Created by Riccardo Mottola on Wed Oct 12 2005.
//  Copyright (c) 2005-2008 Carduus. All rights reserved.
//
// This application is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any later version.
// This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

#import "PRImage.h"


@implementation PRImage

- (void)addRepresentation:(NSImageRep *)imageRep
{
    [super addRepresentation:imageRep];
    tiffRep = [[self representations] objectAtIndex:0];
    pixelH = [tiffRep pixelsHigh];
    pixelW = [tiffRep pixelsWide];
    bitsPerPixel = [tiffRep bitsPerPixel];
}

- (id)initWithData:(NSData*)data
{
    self = [super initWithData:data];
    tiffRep = [[self representations] objectAtIndex:0];
    pixelH = [tiffRep pixelsHigh];
    pixelW = [tiffRep pixelsWide];
    bitsPerPixel = [tiffRep bitsPerPixel];
    return self;
}

- (id)initWithSize:(NSSize)aSize
{
    self = [super initWithSize:aSize];
    return self;
}

- (void)dealloc
{
    [super dealloc];
}

- (void)setSize:(NSSize)aSize
{
    [super setSize:aSize];
    pixelH = [tiffRep pixelsHigh];
    pixelW = [tiffRep pixelsWide];
}

- (int)height
{
    return pixelH;
}

- (int)width
{
    return pixelW;
}

- (int)bitsPP
{
    return bitsPerPixel;
}

- (NSBitmapImageRep *)tiffRep
{
    return tiffRep;
}

@end
