#ifndef CONF_H
#define CONF_H

/* units */

#define bytes		   1
#define kilobytes	1024

#define seconds		   1
#define minutes		  60
#define hours		3600

#define signed_integer_percent	   1



typedef struct _preload_conf_t
{
  /* conf values.  see preload.conf for a description of these */
  /* all time and size values here are in seconds and bytes,
   * unlike in the config file */

  struct _conf_model {
    int cycle;
    gboolean usecorrelation;

    int minsize;

    /* memory usage adjustment */
    int memtotal;
    int memfree;
    int memcached;
  } model;

  struct _conf_system {
    gboolean doscan;
    gboolean dopredict;
    int autosave;
    char **mapprefix;
    char **exeprefix;
  } system;

} preload_conf_t;

extern preload_conf_t conf[1];


void preload_conf_load (const char *conffile, gboolean fail);
void preload_conf_dump_log (void);

#endif
