/*
 Copyright (C) 2011 Sergio Spinatelli <spinatelli.sergio@gmail.com>

 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2.1 of the License, or (at your option) any later version.

 See the file COPYING for the full license text.
*/
public class Postler.State : GLib.Object {
    string config_path;
    string state_file;
    string group = "state";
    GLib.KeyFile keyfile;

    public int width { get; set; default = 0; }
    public int height { get; set; default = 0; }
    public int window_state { get; set; default = 0; }
    public string open_folder { get; set; default = ""; }

    public State () {
        unowned string config_dir = Environment.get_user_config_dir ();
        config_path = config_dir + "/" + Config.PACKAGE_NAME + "/";
        state_file = config_path + "staterc";

        reload ();
    }

    void write_keyfile () throws Error {
        if (DirUtils.create_with_parents (config_path, 0700) != 0)
            throw new GLib.FileError.FAILED (_("Config folder couldn't be created."));
        FileUtils.set_contents (state_file, keyfile.to_data ());
    }

    public void update () {
        try {
            keyfile.set_integer (group, "width", width);
            keyfile.set_integer (group, "height", height);
            keyfile.set_integer (group, "window-state", window_state);
            keyfile.set_string (group, "open-folder", open_folder);

            write_keyfile ();
        } catch (GLib.Error error) {
            GLib.critical ("Failed to save \"%s\": %s", state_file, error.message);
        }
    }

    void reload () {
        keyfile = new GLib.KeyFile ();
        try {
            keyfile.load_from_file (state_file, 0);
        }
        catch (GLib.Error error) {
            GLib.debug ("Failed to load \"%s\": %s", state_file, error.message);
        }

        try {
            if (keyfile.has_key (group, "width"))
                width = keyfile.get_integer (group, "width");
            if (keyfile.has_key (group, "height"))
                height = keyfile.get_integer (group, "height");
            if (keyfile.has_key (group, "window-state"))
                window_state = keyfile.get_integer (group, "window-state");
            if (keyfile.has_key (group, "open-folder"))
                open_folder = keyfile.get_string (group, "open-folder");
        } catch (GLib.Error error) {
            /* i18n: File was found but contains invalid values */
            GLib.critical (_("Failed to parse state in \"%s\": %s"),
                             state_file, error.message);
        }
    }
}
