/* GNU polyxmass - the massist's program.
   -------------------------------------- 
   Copyright (C) 2000,2001,2002,2003,2004 Filippo Rusconi

   http://www.polyxmass.org

   This file is part of the "GNU polyxmass" project.
   
   The "GNU polyxmass" project is an official GNU project package (see
   www.gnu.org) released ---in its entirety--- under the GNU General
   Public License and was started at the Centre National de la
   Recherche Scientifique (FRANCE), that granted me the formal
   authorization to publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU  General Public
   License along with this software; if not, write to the
   Free Software Foundation, Inc., 51 Franklin St, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/
#include "polyxdef-ui-syntaxcheck.h"



GtkWidget *
polyxdef_ui_syntaxcheck_wnd_setup_window (PxmDefCtxt *defctxt, 
					  gchar *errors)
{
  GtkWidget *widget = NULL;
  GtkTextIter text_iter;
  GtkTextBuffer *buffer = NULL;
  
  GladeXML *xml = NULL;

  gchar *help = NULL;
  gchar *gui_file = NULL;


  g_assert (defctxt != NULL);
  

  /* We are asked to setup a window to display the string 'errors' that 
     is passed as a parameter to this function.

     Note that this window might be used both for reporting atom
     definition errors and for reporting polymer chemistry definition
     errors.

     We will do the difference between the two cases by looking at the
     defctxt->definition_type variable content.
  */



  /* Create the window into which the errors string is to be displayed
   * into the treeview.
   */  
  gui_file = 
    g_strdup_printf ("%s/polyxdef.glade", userspec->gladedir);

  g_assert (gui_file != NULL);
  
  xml = glade_xml_new (gui_file, "polyxdef_check_errors_wnd", 
		       PACKAGE);
  if (xml == NULL)
    {
      g_critical (_("%s@%d: failed to load the interface\n"),
	     __FILE__, __LINE__);

      return NULL;
    }

  defctxt->syntax_check_wnd = 
    glade_xml_get_widget (xml, "polyxdef_check_errors_wnd");
  
  if (defctxt->syntax_check_wnd == NULL)
    {
      g_critical (_("%s@%d: failed to create the syntax-checking window\n"),
	     __FILE__, __LINE__);

      return NULL;
    }

  /* Set the title to the window.
   */
  if (defctxt->definition_type == ATOM_DEF)
    {
      help = g_strdup (_("Atom Definition Syntax Check"));
    }
  else if (defctxt->definition_type == POLCHEM_DEF)
    {
      help = g_strdup (_("Polymer Chemistry Definition Syntax Check"));
    }
  else
    g_assert_not_reached ();


  /* Finally prepare the textview widget...
   */
  widget = glade_xml_get_widget (xml, "definition_check_textview");
  g_object_set_data (G_OBJECT (defctxt->syntax_check_wnd),
		     "definition_check_textview", widget);
  
  /* This function might be called with no errors string to be displayed.
   */
  if (errors != NULL)
    {
      buffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW (widget));
      
      /* Get start of buffer; each insertion will revalidate the
       * iterator to point to just after the inserted text.
       */
      gtk_text_buffer_get_iter_at_offset (buffer, &text_iter, 0);
      
      gtk_text_buffer_insert (buffer, &text_iter, errors, -1);
    }
  
  /* We don't need the GladeXML object any more, so unref it
   * to save some memory 
   */
  g_object_unref (G_OBJECT (xml));
  
  g_signal_connect 
    (G_OBJECT (defctxt->syntax_check_wnd),
     "delete_event",
     G_CALLBACK (polyxdef_ui_syntaxcheck_wnd_delete_event),
     defctxt);
  
  g_signal_connect
    (G_OBJECT (defctxt->syntax_check_wnd),
     "destroy_event",
     G_CALLBACK (polyxdef_ui_syntaxcheck_wnd_destroy_event),
     defctxt);

  g_free (gui_file);

  gtk_widget_show_all (defctxt->syntax_check_wnd);

  
  return defctxt->syntax_check_wnd;
}


void
polyxdef_ui_syntaxcheck_wnd_reset (PxmDefCtxt *defctxt)
{
  GtkTextView *textview = NULL;
  GtkTextBuffer *buffer = NULL;

  GtkTextIter text_iter_start;
  GtkTextIter text_iter_end;

  g_assert (defctxt != NULL);
  g_assert (defctxt->syntax_check_wnd != NULL);

  /* Prepare the textview widget... and reset it to empty.
   */
  textview = g_object_get_data (G_OBJECT (defctxt->syntax_check_wnd),
				"definition_check_textview");
  
  buffer = gtk_text_view_get_buffer (textview);
  
  gtk_text_buffer_get_iter_at_offset (buffer, &text_iter_start, 0);
  gtk_text_buffer_get_iter_at_offset (buffer, &text_iter_end, -1);
  
  gtk_text_buffer_delete (buffer, &text_iter_start, &text_iter_end);
  
  return;
}


void
polyxdef_ui_syntaxcheck_wnd_set_errors (PxmDefCtxt *defctxt, gchar *errors)
{
  GtkTextView *textview = NULL;
  GtkTextBuffer *buffer = NULL;

  GtkTextIter text_iter_end;
  
  g_assert (defctxt != NULL);
  g_assert (defctxt->syntax_check_wnd != NULL);
  g_assert (errors != NULL);
  

  /* Prepare the textview widget... and set the text to it. This is an
     "append", so we first have to get the end_iter.
  */
  textview = g_object_get_data (G_OBJECT (defctxt->syntax_check_wnd),
				"definition_check_textview");
  
  buffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW (textview));
  
  /* Get end of buffer; each insertion will revalidate the iterator to
     point to just after the inserted text.
  */
  gtk_text_buffer_get_iter_at_offset (buffer, &text_iter_end, -1);

  gtk_text_buffer_insert (buffer, &text_iter_end, errors, -1);

  gtk_widget_show_all (GTK_WIDGET (defctxt->syntax_check_wnd));
  
  return;
}



gboolean
polyxdef_ui_syntaxcheck_wnd_delete_event (GtkWidget *window,
					  GdkEvent *event,
					  gpointer data)
{
  PxmDefCtxt *defctxt = data;

  g_assert (defctxt->syntax_check_wnd != NULL);

  gtk_widget_hide (GTK_WIDGET (defctxt->syntax_check_wnd));
  
  return TRUE;
}


gboolean
polyxdef_ui_syntaxcheck_wnd_destroy_event (GtkWidget *window,
					   GdkEvent *event,
					   gpointer data)
{
  return FALSE;
}
