import util

import patterns

import string
pattern_realizations = {} # deprecate
pattern_assertions = {}
pattern_assertions_final = {}
all_pattern_realizations = {}
from te_gen_util import *

"""For generating .te and .fc files from pattern instances"""

class PatternAssertion:
    """Equivalence class of pattern constellations all with the same
    security context"""
    def __init__(self,patternstr, specstr, mode):
        self.accepted = 1 # innocent until proven guilty
        if mode.name in ['out_of_scope', 'violator']:
            self.accepted = 0
        self.evidence = {} # a set of uids for PatternR's
        self.print_form = specstr
        self.treat_as = mode
        self.pattern = patternstr
        self.uid = "pa" + uid_gen.bump()
        uid2name[self.uid] = specstr
        pattern_assertions[self.uid] = self

class PatternFinal:
    """Equivalence class of pattern constellations all with the same
    security context"""
    def __init__(self,patternstr, specstr, accepted):
        self.accepted = accepted
        self.evidence = {} # a set of uids for PatternR's
        self.print_form = specstr
        #self.treat_as = mode
        self.pattern = patternstr
        self.uid = "pa" + uid_gen.bump()
        uid2name[self.uid] = specstr
        pattern_assertions_final[self.uid] = self



class PatternR:
    """ Individual pattern constellation"""
    elements = [] #obsolete
    participants = []
    requires_resource_types = 0
    def te(self):
        """returns line feed delimited string
         When invoked args will be strings"""
        ans = ""
        for c in self.elements:
              ans = ans + (c.te() + '\n')
        return ans
    def spec(self):
        """Returns macro instances"""
        patname = the_type(self)[:-1]
        participants = eval('patterns.' + patname).participants
        #print participants
        toreturn = macro_name(patname) + '('
        for p in participants:
            obj = getattr(self, p)
            #print "%%%%%%" + obj.get_sc()
            add_type = ""
            objtype = context2type(obj.get_sc())
            if self.requires_resource_types and objtype not in ['Process']:
                add_type = ',' + objtype.lower() 
            toreturn = toreturn + ' ' + context2type(obj.get_sc()) \
                       + add_type + ","
        toreturn = toreturn[:-1] + ') \n'
        return toreturn
    def contains_external (self):
        toreturn = False
        patname = the_type(self)[:-1]
        participants = eval('patterns.' + patname).participants
        #print participants
        for p in participants:
            obj = getattr(self, p)
            objtype = context2type(obj.get_sc())
            #print objtype
            if not contains_str(objtype, get_current_program().name):
                if not objtype == 'self':
                    toreturn = True
                    break
        #print toreturn
        return toreturn





class CanUnixConnectR (PatternR):
    def __init__(self, app, socket, registerp = 1):
          self.app = app
          self.socket = socket
          if registerp:
                pat_realizations.append(self)

    def spec(self):
        return "CanUnixConnectR('" + self.app.get_sc()  + "')"

    def te(self):
      return write_te_macro('can_unix_connect', [self.app, self.socket])

class DontAuditR (PatternR):
    def __init__(self, app, fl, fl_type, permissions, registerp = 1):
          self.app = app
          self.fl = fl
          self.fl_type = fl_type
          self.permissions = permissions
          if registerp:
                pat_realizations.append(self)

    def spec(self):
        return "DontAuditR('" + self.app.get_sc() + "','" + self.fl.get_sc() + "')"

    def te(self):
      return write_te_macro('dontaudit', [self.app, self.fl])

class CanExecR (PatternR):
     def __init__(self,parent,spawned, registerp = 1):
          self.parent = parent
          self.spawned = spawned
          if registerp:
                pat_realizations.append(self)

     def spec(self):
        return "CanExecR('" + self.parent.get_sc() + "','" + self.spawned.get_sc() + "')"

     def te(self):
      return write_te_macro('can_exec', [self.parent, self.spawned])

class AllowR (PatternR):
     def __init__(self,process,holder,holder_type,action, registerp = 1):
          self.process = process
          self.holder = holder
          self.holder_type = holder_type
          if holder_type == 'Socket':
              self.action = 'create_socket_perms'
              self.holder_type = 'unix_stream_socket'

          elif action == 'read' and holder_type == 'File':
               self.action = '{read getattr}'
          elif action == 'read' and holder_type == 'Dir':
              self.action = '{getattr search}'
          elif action == 'open':
              self.action = '{getattr search}'
          else:
              self.action = action
          if registerp:
                pat_realizations.append(self)

     def spec(self):
        if self.process.get_sc() == None:
            self.process_security_context = 'no_context'
        if self.holder.get_sc()== None:
            self.holder_security_context = 'no_context'
        return "AllowR('" + self.process.get_sc() + \
               "','" + self.holder.get_sc() + "','" + self.holder_type.lower() + \
               "','" + self.action + "')"
     def te(self):
        return "allow " + context2type(self.process) + \
               " " + context2type(self.holder) + ": " \
               + self.holder_type.lower() + " " + self.action + ";"

class PipelineR (PatternR):
     def __init__(self,begin,r1,middle,r2,end, registerp = 1):
          self.requires_resource_types = 1
          self.begin = begin
          self.r1 = r1
          self.middle = middle
          self.r2 = r2
          self.end = end
          if registerp:
                pat_realizations.append(self)
          self.elements = [AllowR(begin, r1, get_type(r1), 'write', 0),
                           AllowR(middle, r1, get_type(r1), '{getattr read}', 0),
                           AllowR(middle, r2, get_type(r2), 'write', 0),
                           AllowR(end, r2, get_type(r2), '{getattr read}',0)]

class PipeR (PatternR):
     def __init__(self,parent,pipe,child, registerp = 1):
          self.parent = parent
          self.pipe = pipe
          self.child = child
          if registerp:
                pat_realizations.append(self)
          self.elements = [AllowR(parent, pipe, 'fifo_file', \
                    '{read write getattr}', 0),
                      CanExecR(parent, child, 0)]

class HubAndSpokeR (PatternR):
     def __init__(self, initiator, r2, generator, center, colleague, registerp = 1):
          self.initiator = initiator
          self.r2 = r2
          self.colleague = colleague
          self.generator = generator
          self.center = center
          if registerp:
                pat_realizations.append(self)
          self.elements = [CanExecR(initiator, colleague, 0),
                      CanExecR(initiator, center, 0)]
     def spec(self):
        """Returns macro instance"""
        patname = "HubAndSpoke"
        participants = ['initiator', 'colleague', 'center']
        participant_objs = [getattr(self, p) for p in participants]
        #print participants
        toreturn = macro_name(patname) + '(' + \
                   context2type(participant_objs[0].get_sc()) + "," + \
                   context2type(participant_objs[1].get_sc()) + "," + \
                   context2type(participant_objs[1].get_sc()) + "," + \
                   context2type(participant_objs[2].get_sc()) + "," + \
                   context2type(participant_objs[2].get_sc()) + ') \n'
#     toreturn = ""
        return toreturn
          
class ProxyR (PatternR):
     def __init__(self,proxy,r2,service,r3,client, registerp = 1):
          self.requires_resource_types = 1
          self.proxy = proxy
          self.r2 = r2
          self.service = service
          self.r3 = r3
          self.client = client
          if registerp:
                pat_realizations.append(self)
          self.elements = [AllowR(proxy, r2, get_type(r2), 'write', 0),
                           AllowR(service, r2, get_type(r2), '{read getattr}', 0),
                           AllowR(proxy, r3, get_type(r3), '{read getattr}', 0),
                           AllowR(service, r3, get_type(r3), 'write', 0)]

class ObserverR (PatternR):
     def __init__(self,observer,service,client, registerp = 1):
          self.observer = observer
          self.service = service
          self.client = client
          if registerp:
                pat_realizations.append(self)

class LoggerR (PatternR):
     def __init__(self,application,log_file, registerp = 1):
          self.application = application
          self.log_file = log_file
          if registerp:
                pat_realizations.append(self)
          self.elements = [AllowR(application, log_file, 'file', '{create append}', 0)]

class LibSelinuxInitR (PatternR):
     def __init__(self,application,mounts,new_access, registerp = 1):
          self.application = application
          self.mounts = mounts
          self.new_access = new_access
          if registerp:
                pat_realizations.append(self)
          self.elements = [AllowR(application, mounts, 'dir', 'search', 0), \
                           AllowR(application, mounts, 'file', '{getattr read}', 0)]
          self.alternate_elements = [DontAuditR(application, mounts, 'file', 're_file_perms')]

class SharedLibraryR (PatternR):
     def __init__(self,application,lib_read, registerp = 1):
          self.application = application
          self.lib_read = lib_read
          if registerp:
                pat_realizations.append(self)
          self.elements = [AllowR(application, lib_read, 'file', '{getattr read}', 0)]

class TempUseR (PatternR):
     def __init__(self,application,temp_file, registerp = 1):
          self.application = application
          self.temp_file = temp_file
          if registerp:
                pat_realizations.append(self)
          self.elements = [AllowR(application, temp_file, 'file', '{getattr read write}', 0)]

class ConfigR (PatternR):
     def __init__(self,application,config_file, registerp = 1):
          self.application = application
          self.config_file = config_file
          if registerp:
                pat_realizations.append(self)
          self.elements = [AllowR(application, config_file, 'file', '{getattr read}', 0)]

class CanCheckSelinuxR (PatternR):
     def __init__(self,main,filesystems,current, registerp = 1):
          self.main = main
          self.filesystems = filesystems
          self.current = current
          if registerp:
                pat_realizations.append(self)
          self.elements = [AllowR(main, filesystems, 'file, {getattr read}', 0),
                           AllowR(main, current, 'file', '{getattr read}',0)]

class ActiveObjectR (PatternR):
     def __init__(self,proxy, order, service, filled_order, registerp = 1):
          self.proxy = proxy
          self.order = order
          self.service = service
          self.filled_order = filled_order
          if registerp:
                pat_realizations.append(self)

class CGIR (PatternR):
     def __init__(self,server,r1,shell, script, registerp = 1):
          self.server = server
          self.r1 = r1
          self.shell = shell
          self.script = script
          if registerp:
                pat_realizations.append(self)
                
class ReactorR (PatternR):
     def __init__(self,reactor,demultiplexer,event_handler,handle, registerp = 1):
          self.reactor = reactor
          self.demultiplexer = demultiplexer
          self.event_handler = event_handler
          self.handle = handle
          if registerp:
                pat_realizations.append(self)

class InterpreterR (PatternR):
     def __init__(self,application,code_file,interpreter, registerp = 1):
          self.application = application
          self.code_file = code_file
          self.interpreter = interpreter
          if registerp:
                pat_realizations.append(self)
          self.elements = [AllowR(application, code_file, 'file', 'rx_file_perms',0),
                           AllowR(application, interpreter, 'file', '{getattr execute}',0)]

class MediatorR (PatternR):
     def __init__(self,mediator,r2,r3,colleague, registerp = 1):
          self.mediator = mediator
          self.r2 = r2
          self.r3 = r3
          self.colleague = colleague
          if registerp:
                pat_realizations.append(self)

class ClientServerR (PatternR):
     def __init__(self,client, socket, server, registerp = 1):
          self.requires_resource_types = 1
          self.server = server
          self.socket = socket
          self.client = client
          if registerp:
                pat_realizations.append(self)
          self.elements = [AllowR(client, socket, get_type(socket), '{create connect read getattr write setattr}', 0),
                           AllowR(server, socket, get_type(socket), '{bind listen accept read write}', 0)]

class ExecutableR (PatternR):
     def __init__(self, application, file, process, registerp = 1):
          self.application = application
          self.file = file
          self.process = process
          if registerp:
                pat_realizations.append(self)

class DaemonR (PatternR):
     def __init__(self, parent, child, registerp = 1):
          self.parent = parent 
          self.child = child
          if registerp:
                pat_realizations.append(self)
     def spec (self):
         patname = 'Daemon'
         return macro_name(patname) + '(' + util.PRGM.name + ') \n'

          
                
class ClientR (PatternR):
     def __init__(self,client, socket,  registerp = 1):
          self.requires_resource_types = 1
          self.socket = socket
          self.client = client
          if registerp:
                pat_realizations.append(self)
          self.elements = [AllowR(client, socket, get_type(socket), '{create connect read getattr write setattr}', 0)]

class SingleProcessMediatorR (PatternR):
     def __init__(self,mediator,r1, registerp = 1):
          self.requires_resource_types = 1
          self.mediator = mediator
          self.r1 = r1
          if registerp:
                pat_realizations.append(self)
          self.elements = [AllowR(mediator, r1, get_type(r1), '{read getattr write}',0)]

################## factories #########################
          
def pattern_assertion_factory (printstr, realization, mode):
    there = [pa for pa in pattern_assertions.values() \
             if pa.print_form == printstr
             and pa.treat_as == mode]
    if len(there) != 0:
        found = there[0]
        found.evidence.append(realization.uid)
    else:
        found = PatternAssertion(realization.pattern, printstr, mode)
        found.evidence = [realization.uid]
    realization.assertion = found
    return found

def pattern_assertion_final_factory (preal):
    there = [pa for pa in pattern_assertions_final.values() \
             if pa.print_form == preal.spec()
             and pa.accepted == preal.active]
    if len(there) != 0:
        found = there[0]
        found.evidence.append(preal.uid)
    else:
        found = PatternFinal(preal.pattern, preal.spec(), preal.active)
        found.evidence = [preal.uid]
    preal.assertion = found
    return found
    
def report_prs ():
    for r in all_pattern_realizations.values():
	participants = r.participants
	if len(participants) > 2:
		scs = [context2type(x.get_sc()) for x in participants[1:]]
	        print str(scs)

def macro_name(s):
    """Given a camelcase string naming some pattern, return the macro
    name which represents appropriate policy for that pattern.

    For example:

    >>> macro_name('SingleProcessMediator')
    'polgen_single_process_mediator'
    """
    accum = ['polgen']
    for c in s:
        if c in string.uppercase:
            accum.append('_')
            accum.append(string.lower(c))
        else:
            accum.append(c)
    return ''.join(accum)	        
