from util import *
from textentry import group_name_map
import pr

global error_debug
error_debug = False

history = []



class SC_Operator:
    problem = "sc_operator error"
    def __init__ (self, actorstr = 'polgen'):
        name = 'operator'
        seq_nbr = PRGM.history_nbr
        self.uid = name + "_" + str(seq_nbr)
        self.name = name
        self.applied = 1
        self.new_value = ""
        self.actorstr = actorstr
        self.sequence_nbr = seq_nbr
        PRGM.history_nbr = seq_nbr + 1
        operator_sequence[seq_nbr] = self

    def __repr__ (self):
        return "operator: " + self.name
    
    def error_report (self, string):
        """ behavior when preconditions are not met"""
        global error_debug
        if error_debug:
            print self.input
            print string

class TY_Split (SC_Operator):
    problem = "Resources have more than one type"
    def go (self, resources, name = 'ty_split'):
        """ Initially resources all have same type"""
        self.input = resources
        self.name = name
        sts = seq2set([context2type(r.get_sc()) for r in resources])
        #applicability
        if len(sts) > 1:
            self.applied = 0
            self.error_report(self.problem)
        else:
            st = sts[0]
            base = st[:-2] + '_'
            index = 0
            count = PRGM.operator_nbr
            while index < len(resources):
                index = index + 1
                count = count + 1
                new_st = base + str(count) + "_t"
                TY_Replace().go(resources[index -1], new_st)
            PRGM.operator_nbr = PRGM.operator_nbr + len(resources)

class TY_Merge (SC_Operator):
    problem = "Resources have same type"
    def go (self, resources, name = 'ty_merge'):
        """ Initially resources all have different types"""
        self.input = resources
        self.name = name
        sts = seq2set([context2type(r.get_sc()) for r in resources])
        #applicability
        if len(sts) == 1:
            self.error_report(self.problem)
            self.applied = 0
        else:
            ty = PRGM.name_for_type + '_' + name + '_' + str(PRGM.operator_nbr) + '_t'
            print "Merging " + str([x.name + ":" + x.get_sc()[:-1]  for x in resources])
            for item in resources:
                TY_Replace().go(item, ty)
            PRGM.operator_nbr = PRGM.operator_nbr + 1

class TY_From_Contributors (SC_Operator):
    problem = 'Typing is generally restricted or value is already set'
    def go (self, f, value, name = 'ty_from_contributors'):
        """note: value is a substring like all, group1, config or it is
        the original security_context"""
        self.name = name
        self.input = [f]
        self.new_value = value
        stype = final_stype(f, value) # converts value to final form
        there = f.get_sc()
        if PRGM.unlimited_typing and there != value:
            self.new_value = stype
            f.set_sc(user_and_role(there) + stype, 'from gui and contributors')
        #applicability
        else:
            self.error_report(self.problem)
            self.applied = 0
            
    def __repr__(self):
        return 'operator: ' + self.name + " " + self.input[0].name \
               + ' with ' + self.new_value


class TY_Replace (SC_Operator):
    problem = "Resource's type is already set to desired value"
    def go (self, resource, final_value, support = 'high', name = 'ty_replace'):
        """ here final_value is of the form xxx_t"""
        self.input = [resource]
        self.name = name
        #applicability
        if context2type(resource.get_sc()) == final_value:
            self.new_value = final_value + '(no change)'
            #self.error_report(self.problem)
            self.applied = 0
        else:
            self.modify(resource, final_value, support)
        
    def modify (self, resource,type_value, support):
        """Changing type of resource.name  to type_value 
        (orig was context2type(resource.original_context))"""
        u_and_r = user_and_role(resource.get_sc())
        self.new_value = type_value
        resource.set_sc(u_and_r + type_value, support)
        
    def __repr__(self):
        return 'operator: ' + self.name + " " + self.input[0].name \
               + ' with ' + self.new_value

class Multiple_Transition_Strategy (SC_Operator):
    """problem_values is a set of pattern_realizations"""
    problem = "all problem values have same type"
    def go (self, name = 'ty_multiple_transition'):
        print "use subclass"
    
#obsolete
class TY_Revert (Multiple_Transition_Strategy):
    def go (self, problem_values, name = 'ty_revert'):
        """Strategy that reverts to the highest category of type""" 
        categories = ['polgen_temp', 'domain', 'unconfined']
        self.name = name
        self.input = problem_values
        print "Revert to highest category for " + str([x.spec() for x in problem_values])
        revert_aux(problem_values)

class TY_Repair_Multiple_Trans (Multiple_Transition_Strategy):
    def go (self, problem_values, name = 'ty_repair_mult_trans'):
        """retract assertion of executable macro associated with non-polgen_temp type"""
        self.name = name
        self.input = problem_values
        self.mt_repair_strategy(problem_values)

    def mt_repair_strategy (self, problem):
        """problem is set of realizations of Executable pattern.
        Resolution is to only have executable macro for a single polgen_temp type"""
        types = [[e, context2type(e.participants[2].get_sc())] for e in problem]
        good = [x for x in types if x[1].find('polgen_temp') != -1 or x[1].find(PRGM.name_for_type) != -1]
        #print good
        if len(good) == 0:
            print "nothing to choose from"
            return
        keep = good[0][0]
        if len(good) > 1:
            winner = 0
            for g in good:
                if context2type(g[0].participants[0].get_sc()) == \
                   context2type(g[0].participants[2].get_sc()):
                                keep = g[0]
                                winner = 1
                                break
            if not winner: # no obvious candidate
                TY_Merge().go([x[0].participants[2] for x in good])
                keep  = good[0][0]
        elif len(good) == 0:
            print "???How to merge " + str([x[0].participants[2].name for x in types])
        else: # only one polgen_temp type
            keep = good[0][0]
        if keep != None:
            #print "There are " + str(len(types)) + " types in this problem"
            already_set = 0
            for p in types:
                # there will be only one active - rest are not active
                if not already_set and (p[0].participants[2].get_sc() == keep.participants[2].get_sc()):
                    active = 1
                    already_set = 1
                else:
                    active = 0
                if p[0].assertion.accepted != active:
                    print "Adjusting accepted status for " + p[0].spec() + " to " + str(active)
                    TY_Adjust_Active().go(p[0].assertion, active, "Repair Multi-transition conflict")
        
            
class TY_Adjust_Active (SC_Operator):
    def go (self, assertion, val, reason):
         assertion.accepted = val
         for e in assertion.evidence: # go to pattern realizations supporting assertion
            there = pr.all_pattern_realizations[e].active
            if there != val:
                post(pr.all_pattern_realizations[e], 'active', val)
                pr.all_pattern_realizations[e].active = val
                pr.all_pattern_realizations[e].reason = reason



    
################### supporting utilities #################
            
def final_stype(f, value):
    """value is all, group, pattern, or original sc"""
    keys = group_name_map.keys()
    if value == 'all':
        st = get_stype_from_all_contributors(f)
    elif value in f.type_contributors:
        if value in keys:
            value = group_name_map[value]
        st = PRGM.name_for_type + '_' + value + "_t"
    else: # user wants original to stand
        st = context2type(f.original_context)
    return st



#obsolete
def revert_aux (problem):
    """realizations is set of patternR's"""
    done = 0
    for e in problem:
        third = context2type(e.participants[2].get_sc())
        if third.find('unconfined_t') != -1: # ty is unconfined_t
            done = 1
            #print "found unconfined"
            for e in problem:
                TY_Replace().go(e.participants[2], 'unconfined_t')
            break
    if not done:
        use = []
        for e in problem:
            third = context2type(e.participants[2].get_sc())
            if not third.find('polgen_temp') != -1: # domain level
                 use.append(third)
                 #print "found temp"
        use = seq2set(use)
        if len(use) == 0: #all temp
            print "all temp"
            TY_Merge().go([x.participants[2] for x in problem])
        elif len(use) == 1: # use this one
            print "Use " + use[0]
            for e in problem:
                TY_Replace().go(e.participants[2], use[0])
        else: # more than one domain involved
            print "Multiple domain options for transition: Selecting "  \
                      + use[0] + " from " + str(use) + " options."
            for e in problem:                
                TY_Replace().go(e.participants[2], use[0])
    #print "reverting"


         
def get_stype_from_all_contributors(f):
    """ returns reasonable type from contributors """
    stype = PRGM.name_for_type + '_'
    keys = group_name_map.keys()
    if f.type_contributors == []: # won't be here from gui; could be here when spar must decide
        there = context2type(f.get_sc())
        #replace 'polgen_temp' with program name
        return context2type(temp_type_replacement(f))
    else:
        f.type_contributors.sort()
        for item in f.type_contributors: # patterns and groups
            if item in keys: # is item a group name
                item = group_name_map[item]
                #else item is the name of a pattern - must be a pattern that forces resource type changes -
                # otherwise we would not be here
            stype = stype + item + '_'
        return stype + 't'
        
def get_stype_from_contributor(contributor):
    """returns print form of a type - used in generating option fields"""
    if contributor == 'all':
        return "all"
    keys = group_name_map.keys()
    stype = PRGM.name_for_type + '_'
    if contributor in keys:
        contributor = group_name_map[contributor]
    stype = stype + contributor + "_t"
    return stype

def temp_type_replacement(f):
    """returning a full security_context"""
    pos = f.get_sc().find(f.default_type)
    if pos != -1: # default still in place
        return f.get_sc()[0:pos] + PRGM.name_for_type + \
                             f.get_sc()[pos + len(f.default_type):]
    else:
        return f.get_sc()

   
def get_stype_from_all_contributors(f):
    """ returns reasonable type from contributors """
    stype = PRGM.name_for_type + '_'
    keys = group_name_map.keys()
    if f.type_contributors == []: # won't be here from gui; could be here when spar must decide
        there = context2type(f.get_sc())
        #replace 'polgen_temp' with program name
        return context2type(temp_type_replacement(f))
    else:
        f.type_contributors.sort()
        for item in f.type_contributors: # patterns and groups
            if item in keys: # is item a group name
                item = group_name_map[item]
                #else item is the name of a pattern - must be a pattern that forces resource type changes -
                # otherwise we would not be here
            stype = stype + item + '_'
        return stype + 't'
        
def get_stype_from_contributor(contributor):
    """returns print form of a type - used in generating option fields"""
    if contributor == 'all':
        return "all"
    keys = group_name_map.keys()
    stype = PRGM.name_for_type + '_'
    if contributor in keys:
        contributor = group_name_map[contributor]
    stype = stype + contributor + "_t"
    return stype


def post (obj, relation, value):
    history.append([obj, relation, value])
    return 'done'
