from home_txt import beginnings, ending
from pres_util import *
from util import *
import config

def gen():
    prgm = get_current_program()
    pname = prgm.name
    preloadfileid  = "preload.html"
    preloadfileStr = config.result_file(preloadfileid)
    preloadout = open(preloadfileStr, "w")
    preloadout.write('<html></html>')
    preloadout.close()
    homefileid  = "home.html"
    
    homefileStr = config.result_file(homefileid)
    homeout = open(homefileStr, "w")
    print "Writing to " + homefileStr
    gen_text_for_home(homeout)
    homeout.close()
    mainfileid  = "main.html"
    mainfileStr = config.result_file(mainfileid)
    mainout = open(mainfileStr, "w")
    print "Writing to " + mainfileStr
    top_of_file(mainout, "Policy Generation Support for " + capitalize_it(pname))
    gen_text_for_main(mainout)
    mainout.close()

treelinks = {}
class TreeLink:
    def __init__(self, name, desc, link = None, parent = None):
        self.name = name
        self.link = link
        self.desc = desc
        self.parent = parent
        if parent != None:
            treelinks[name] = self

root = TreeLink('root', 'top')
data = TreeLink ('Data','tracked files', None, root)
summary = TreeLink('Background', 'security context, pattern instances', None, root)
tocheck = TreeLink('ToCheck', 'possible issues for policy administration', None, root)
output = TreeLink('Policy', 'policy files', None, root)
standard = TreeLink('Standard', 'standard .te, .fc. files', None , output)
ref = TreeLink('Reference', 'reference policy - .te., .fc, .inf files', None, output)


TreeLink('Applications', \
         'Information organized by application; including spawned processes, execs that failed', \
         'Applications', summary)
TreeLink('Security Context', \
         'Information organized by security context including resources associated with each context; some contexts generated in pattern recovery phase', \
         'Security-Context', summary)
TreeLink('Pattern Instances', 'Instances of patterns found in the Polgen trace output', \
         'Pattern-Instances', summary)
TreeLink('Resources', 'Listing of all resources found in the trace', \
         'PolicyHelp', summary)
TreeLink('External References' , 'Reads/Writes involving external respources', \
         'Interface', tocheck)
TreeLink('Uncovered Transitions' , 'Executable patterns rejected due to transitions involving external resources or due to user choice', \
         'Uncovered-Execs', tocheck)
TreeLink('External Overrides' ,'Report on external resources whose security context was either changed or not with respect to patterns or information flow groups', \
         'Override_Issues', tocheck)
TreeLink('Sub-process Extensions', 'Sub-processes such as cgi scripts that may attempt to access resources beyond those accessed by the parent process', \
         'CGI', tocheck)
TreeLink('Contexts to Check','Items where there were multiple choices and either polgen or the user made a decision to set a security context',\
         'ToDo', tocheck)
TreeLink('.te file' ,'Polgen generated te file', 'te', standard)
TreeLink('.fc file' ,'Polgen generated fc file', 'fc', standard)

TreeLink('Reference .te' ,'Polgen generated te file', 'Ref-te', ref)
TreeLink('Referernce .fc ' ,'Polgen generated fc file', 'Ref-fc', ref)
TreeLink('Reference .inf' ,'Polgen generated inf file', 'Ref-inf', ref)
TreeLink('Boundary Crossing' ,'Pattern instances that cross module boundaries', 'boundary_crossings', ref)
                        
def add_tracked ():
    source_list = [x.name for x in get_current_program().sources]
    for t in applications:
        if 'tracked' in source_list:
            fname = PRGM.name + '.tracked'
            TreeLink(fname, 'Tracked file for ' + t.name, fname, data)
        if 'psl' in source_list:
            pslname = PRGM.name + '.psl'
            TreeLink(pslname, 'Psl file for ' + t.name, pslname, data)
        if 'psl' in source_list and 'tracked' in source_list:
            TreeLink('Differences', 'Differences', 'diff', data)
        
def gen_text_for_home(strm):
    add_tracked()
    strm.write(beginnings + " \n") # might be problem with \n's embedded in text
    for item in [data, summary, tocheck, output, standard, ref]:
        gen_folder(strm, item, item.parent)
    for item in treelinks.values():
        if item.link != None:
            gen_text_for_home_aux(strm, item)
    strm.write(ending)

def gen_folder (strm, item, parent = root):
    #print parent
    strm.write("     treeData.add(new FolderNode('" + item.name \
               + "','" + parent.name + "','" + item.name + "','',''));   \n")
    
def gen_text_for_home_aux(strm, item):
    add_tree_link(strm, item.parent.name, item.name, item.link)

def add_tree_link(strm, parentStr, displayStr, pageIdStr):
    append = ""
    strm.write("     treeData.add(new LinkNode('" + parentStr + "','" + \
               displayStr + "','" + pageIdStr \
               + ".html','','')); \n")

def gen_text_for_main(strm):
    for item in treelinks.values():
        link = item.link
        if link != None:
            strm.write('<h5><a href = '+ item.link + ".html>" + item.name + '</a></h5> \n')
        strm.write(item.desc + '<br> \n')
