//
// ConsoleCertificateHandler.cpp
//
// $Id: //poco/1.4/NetSSL_OpenSSL/src/ConsoleCertificateHandler.cpp#1 $
//
// Library: NetSSL_OpenSSL
// Package: SSLCore
// Module:  ConsoleCertificateHandler
//
// Copyright (c) 2006-2009, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#include "Poco/Net/ConsoleCertificateHandler.h"
#include <iostream>


namespace Poco {
namespace Net {


ConsoleCertificateHandler::ConsoleCertificateHandler(bool server): InvalidCertificateHandler(server)
{
}


ConsoleCertificateHandler::~ConsoleCertificateHandler()
{
}


void ConsoleCertificateHandler::onInvalidCertificate(const void*, VerificationErrorArgs& errorCert)
{
	const X509Certificate& aCert = errorCert.certificate();
	std::cout << "\n";
	std::cout << "WARNING: Certificate verification failed\n";
	std::cout << "----------------------------------------\n";
	std::cout << "Issuer Name:  " << aCert.issuerName() << "\n";
	std::cout << "Subject Name: " << aCert.subjectName() << "\n\n";
	std::cout << "The certificate yielded the error: " << errorCert.errorMessage() << "\n\n";
	std::cout << "The error occurred in the certificate chain at position " << errorCert.errorDepth() << "\n";
	std::cout << "Accept the certificate (y,n)? ";
	char c;
	std::cin >> c;
	if (c == 'y' || c == 'Y')
		errorCert.setIgnoreError(true);
	else
		errorCert.setIgnoreError(false);
}


} } // namespace Poco::Net
